/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests.dnd;

import com.bitwig.base.testing.JiN;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.flt.app.testing.tests.dnd.BoL;
import com.bitwig.flt.app.testing.tests.dnd.DbT;
import com.bitwig.flt.app.testing.tests.dnd.FIg;
import com.bitwig.flt.app.testing.tests.dnd.Oxx;
import com.bitwig.flt.app.testing.tests.dnd.TAK;
import com.bitwig.flt.app.testing.tests.dnd.UNF;
import com.bitwig.flt.app.testing.tests.dnd.WQ1;
import com.bitwig.flt.app.testing.tests.dnd.htX;
import com.bitwig.flt.app.testing.tests.dnd.kK;
import com.bitwig.flt.app.testing.tests.dnd.ueo;
import com.bitwig.flt.app.testing.vzv;
import com.bitwig.flt.document.core.iface.clipboard.clip.ArrangerClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.clip.ClipLauncherClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.DeviceChainInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.track.OZu;
import com.bitwig.flt.document.core.iface.clipboard.track.TrackHeaderInsertionPoint;
import com.bitwig.flt.document.core.iface.ky;
import com.bitwig.flt.document.core.iface.r2H;
import com.bitwig.flt.document.core.master.device.Sfb;
import com.bitwig.ramona.core.I2N;
import com.bitwig.ramona.core.Pue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AutoDragAndDropTests
extends BitwigStudioTestDataFileTest {
    private TAK mDataSourceCreator;
    private DbT mInsertionPointCreator;
    private TestProject mProject;
    private int mInsertModifiers = -1;
    private BoL mExpectedAction;
    private FIg mExpectedInsertActionsFile;
    private static final String CORRECT_INSERT_ACTION_NAME = "insert-action";
    private static final int MODIFIERS_TO_IGNORE = 0;
    private TestProject mProjectWeOpenedToFindTestHierarchy;
    private List mAllDataSourceCreators;
    private List mAllInsertionPointCreators;

    @Override
    protected String getTopLevelDirectoryPath() {
        return "auto-drag-and-drop/projects";
    }

    @Override
    protected boolean shouldCreateTestForFileType(ouY ouY2) {
        return ouY2 instanceof zLg;
    }

    @Override
    protected boolean hasChildTestsPerFile(GYl gYl) {
        return true;
    }

    @Override
    protected String getTestNodeNameForFile(GYl gYl) {
        return gYl.PB();
    }

    @Override
    public String getTestName() {
        if (this.mDataSourceCreator != null) {
            if (this.mInsertionPointCreator != null) {
                if (this.mInsertModifiers == 0) {
                    return "none";
                }
                if (this.mInsertModifiers != -1) {
                    return Duv.pqd(this.mInsertModifiers);
                }
                return this.mInsertionPointCreator.WCG();
            }
            return this.mDataSourceCreator.WCG();
        }
        return super.getTestName();
    }

    @Override
    protected void listChildrenForFile(GYl gYl, Collection collection) {
        if (this.shouldCreateTestForFile(gYl)) {
            if (this.mDataSourceCreator == null) {
                this.listDataSourceTests(gYl, collection);
            } else if (this.mInsertionPointCreator == null) {
                this.listInsertionPointTests(gYl, collection);
            } else if (this.mInsertModifiers == -1) {
                this.listInsertModifierTests(gYl, collection);
            }
        } else {
            super.listChildrenForFile(gYl, collection);
        }
    }

    private void listDataSourceTests(GYl gYl, Collection collection) {
        assert (bhd.t3p(this.mAllDataSourceCreators == null));
        assert (bhd.t3p(this.mAllInsertionPointCreators == null));
        assert (bhd.t3p(this.mExpectedInsertActionsFile == null));
        GYl gYl2 = gYl.pqd(gYl.PB() + ".expected");
        this.mProjectWeOpenedToFindTestHierarchy = this.openTestProject(gYl);
        this.mAllDataSourceCreators = new ArrayList();
        this.mAllInsertionPointCreators = new ArrayList();
        GYl gYl3 = this.getTopLevelDirectory().aaP().ocA("files");
        gYl3.WCG(new kK(this, gYl3));
        this.exec(() -> {
            Sve sve = (Sve)this.mProjectWeOpenedToFindTestHierarchy.liD();
            this.listDataSourcesAndInsertionPointsForDocument(sve);
        });
        this.mExpectedInsertActionsFile = new FIg(gYl2, this.mAllDataSourceCreators, this.mAllInsertionPointCreators);
        this.exec(() -> {
            for (TAK tAK : this.mAllDataSourceCreators) {
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(gYl, true);
                autoDragAndDropTests.mDataSourceCreator = tAK;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertionPointTests(GYl gYl, Collection collection) {
        assert (bhd.t3p(this.mDataSourceCreator != null));
        assert (bhd.t3p(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            Sve sve = (Sve)this.mProjectWeOpenedToFindTestHierarchy.liD();
            XfY xfY = this.mDataSourceCreator.WCG(sve);
            for (DbT dbT : this.mAllInsertionPointCreators) {
                kGw kGw2 = dbT.WCG(sve);
                if (!kGw2.pqd(xfY)) continue;
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(gYl, true);
                autoDragAndDropTests.mInsertionPointCreator = dbT;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertModifierTests(GYl gYl, Collection collection) {
        assert (bhd.t3p(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            Object object;
            Iterator iterator2;
            Sve sve = (Sve)this.mProjectWeOpenedToFindTestHierarchy.liD();
            XfY xfY = this.mDataSourceCreator.WCG(sve);
            this.check(xfY).LZT();
            kGw kGw2 = this.mInsertionPointCreator.WCG(sve);
            this.check(kGw2).LZT();
            this.check(kGw2.pqd(xfY));
            int n2 = kGw2.ocA(xfY) & 0xFFFFFFFF;
            cLP cLP2 = new cLP(4);
            for (Iterator iterator2 : Duv.WCG(n2)) {
                cLP2.pqd(((Duv)((Object)iterator2)).pqd());
            }
            cLP cLP3 = new cLP(4);
            this.listModifierCombinations(cLP2, cLP3);
            iterator2 = cLP3.W1d();
            while (iterator2.hasNext()) {
                int n3 = (Integer)iterator2.next();
                object = (AutoDragAndDropTests)this.createChild(gYl, false);
                ((AutoDragAndDropTests)object).init(n3);
                collection.add(object);
            }
            for (Duv duv : Duv.WCG) {
                if (duv.t3p(n2) || duv.t3p(0) || (object = this.mExpectedInsertActionsFile.WCG(this.mDataSourceCreator, this.mInsertionPointCreator, duv.pqd())) == null) continue;
                if (((BoL)object).WCG()) {
                    this.checkCorrectable("Did not list " + duv.WCG() + " as a possible insert modifier but the expected actions says that it should be possible", "RemoveInsertModifier", duv.WCG()).WCG("");
                    continue;
                }
                this.mExpectedInsertActionsFile.t3p(this.mDataSourceCreator, this.mInsertionPointCreator, duv.pqd());
            }
        });
    }

    private void listModifierCombinations(cMl cMl2, cMl cMl3) {
        cMl3.pqd(0);
        this.listModifierCombinations(cMl2, cMl3, 0, 0);
    }

    private void listModifierCombinations(cMl cMl2, cMl cMl3, int n2, int n3) {
        for (int i2 = n3; i2 < cMl2.size(); ++i2) {
            int n4 = cMl2.cUO(i2);
            cMl3.pqd(n2 | n4);
            this.listModifierCombinations(cMl2, cMl3, n2, n3 + 1);
            this.listModifierCombinations(cMl2, cMl3, n2 | n4, n3 + 1);
        }
    }

    @Override
    protected void afterTestHierachyUpdated() {
        super.afterTestHierachyUpdated();
        this.mAllDataSourceCreators = null;
        this.mAllInsertionPointCreators = null;
        if (this.mDataSourceCreator == null && this.mProjectWeOpenedToFindTestHierarchy != null && this.getFile() != null && this.getFile().WGS()) {
            try {
                this.mProjectWeOpenedToFindTestHierarchy.PB();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mProjectWeOpenedToFindTestHierarchy = null;
    }

    private void init(int n2) {
        this.mInsertModifiers = n2;
        this.mExpectedAction = this.mExpectedInsertActionsFile.WCG(this.mDataSourceCreator, this.mInsertionPointCreator, n2);
    }

    @Override
    protected com.bitwig.base.testing.BoL getRootTestForSetup() {
        if (this.getFile() != null && this.mDataSourceCreator == null && this.mInsertionPointCreator == null && this.mInsertModifiers == -1) {
            return this;
        }
        return super.getRootTestForSetup();
    }

    @Override
    protected void setupDescendandTest(com.bitwig.base.testing.BoL boL2) {
        super.setupDescendandTest(boL2);
        AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)boL2;
        if (this.mProject == null || ((Sve)this.mProject.liD()).M_()) {
            this.mProject = autoDragAndDropTests.openTestProject(autoDragAndDropTests.getFile());
        }
        vzv vzv2 = (vzv)((Sve)this.mProject.liD()).RTV();
        vzv2.WCG(autoDragAndDropTests);
        autoDragAndDropTests.mProject = new TestProject((BitwigStudioTest)autoDragAndDropTests, (Sve)this.mProject.liD());
        autoDragAndDropTests.openedProject(autoDragAndDropTests.mProject);
    }

    @Override
    protected void tearDownDescendantTest(com.bitwig.base.testing.BoL boL2, boolean bl2) {
        super.tearDownDescendantTest(boL2, bl2);
        if (!bl2) {
            AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)boL2;
            autoDragAndDropTests.mProject.PB();
            this.mProject = null;
        }
    }

    @JiN
    public void testDragAndDrop() {
        if (this.mProject.cUO()) {
            this.mProject.xzw();
        }
        this.mProject.aaP();
        doC doC2 = new doC();
        this.asyncExec(() -> {
            Sve sve = (Sve)this.mProject.liD();
            XfY xfY = this.mDataSourceCreator.WCG(sve);
            this.check(xfY).LZT();
            kGw kGw2 = this.mInsertionPointCreator.WCG(sve);
            this.check(kGw2).LZT();
            int n2 = kGw2.ocA(xfY);
            Ou ou2 = this.mInsertModifiers == 0 || (n2 | this.mInsertModifiers) == n2 ? kGw2.WCG(xfY, this.mInsertModifiers) : null;
            if (ou2 == null) {
                this.checkActionIsExpected(BoL.t3p);
                doC2.WCG();
                return;
            }
            if (!ou2.WCG()) {
                this.checkActionIsExpected(BoL.WCG);
                doC2.WCG();
                return;
            }
            this.asyncExec(() -> {
                ou2.BiT().WCG(true);
                if (ou2.t3p()) {
                    try {
                        ou2.aaP();
                    }
                    catch (bao bao2) {
                        this.checkActionIsExpected(BoL.t3p);
                        doC2.WCG();
                        return;
                    }
                }
                this.asyncExec(() -> {
                    if (ou2.t3p()) {
                        ou2.pqd();
                    }
                    ou2.BiT().WCG(false);
                });
                this.asyncExec(() -> ou2.t3p(this.inNewEvent(l2C.WCG(new UNF(this, sve, ou2, kGw2), doC2))));
            });
        });
        try {
            this.waitForAsyncTask("Insert to finish", doC2, 10L, TimeUnit.SECONDS);
        }
        catch (bao | Pue exception) {
            // empty catch block
        }
        UBy uBy = ((Sve)this.mProject.liD()).D3Y();
        if (uBy != null) {
            this.waitForLatch("Bounce to finish", uBy.hFD(), 10L, TimeUnit.SECONDS);
        }
    }

    private void checkActionIsExpected(BoL boL2) {
        if (this.mExpectedAction == null) {
            if (boL2.WCG()) {
                this.mExpectedInsertActionsFile.WCG(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, boL2);
            }
            this.mExpectedAction = BoL.pqd;
        }
        this.checkCorrectable("Actual insert action is correct", CORRECT_INSERT_ACTION_NAME, boL2).WCG(this.mExpectedAction);
    }

    @Override
    public void autoCorrect(String string, String string2) {
        if (string.equals(CORRECT_INSERT_ACTION_NAME)) {
            try {
                BoL boL2;
                this.mExpectedAction = boL2 = BoL.WCG(string2);
                this.mExpectedInsertActionsFile.WCG(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, boL2);
            }
            catch (vSD vSD2) {
                vSD2.printStackTrace();
            }
        } else if (string.equals("RemoveInsertModifier")) {
            Duv duv = Duv.W1d(string2);
            this.mExpectedInsertActionsFile.t3p(this.mDataSourceCreator, this.mInsertionPointCreator, duv.pqd());
        } else {
            super.autoCorrect(string, string2);
        }
    }

    private void listDataSourcesAndInsertionPointsForDocument(Sve sve) {
        dzt dzt2 = sve.BrA();
        this.listDataSourcesAndInsertionPointsForTrackGroup(dzt2);
        Collections.sort(this.mAllDataSourceCreators);
        Collections.sort(this.mAllInsertionPointCreators);
    }

    private void listDataSourcesAndInsertionPointsForTrackGroup(dzt dzt4) {
        IDj iDj2;
        VgJ vgJ2;
        int n2;
        int n3;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(dzt4);
        for (n3 = 0; n3 < dzt4.QRW(); ++n3) {
            n2 = n3;
            vgJ2 = dzt4.eqW(n2);
            if (vgJ2 instanceof wck) {
                this.listDataSourcesAndInsertionPointsForTrack((wck)vgJ2);
            } else {
                this.listDataSourcesAndInsertionPointsForTrackGroup((dzt)vgJ2);
            }
            this.addInsertionPoint(vgJ2, "Before", vgJ -> new TrackHeaderInsertionPoint(vgJ.Rtf(), J2u.WCG, n2));
        }
        this.addInsertionPoint(dzt4, "EndOfMainTracksIn", dzt2 -> new TrackHeaderInsertionPoint((ky)((Object)dzt2), J2u.WCG, dzt2.QRW()));
        if (dzt4.QRW() > 1) {
            this.addDataSource(dzt4, "AllMainTracksIn", dzt2 -> new OZu(dzt2.oeT()));
        }
        if (dzt4.JGR() > 1) {
            this.addDataSource(dzt4, "AllEffectTracksIn", dzt2 -> new OZu(dzt2.WOb()));
        }
        n3 = 0;
        while (n3 < dzt4.JGR()) {
            n2 = n3++;
            vgJ2 = dzt4.dGg(n2);
            this.listDataSourcesAndInsertionPointsForTrack((wck)vgJ2);
            this.addInsertionPoint(vgJ2, "Before", wck2 -> new TrackHeaderInsertionPoint(wck2.Rtf(), J2u.t3p, n2));
        }
        this.addInsertionPoint(dzt4, "EndOfEffectTracksIn", dzt3 -> new TrackHeaderInsertionPoint((ky)((Object)dzt3), J2u.t3p, dzt4.JGR()));
        IDj iDj3 = AutoDragAndDropTests.firstSceneWithClips(dzt4);
        if (iDj3 != null) {
            this.addDataSource(iDj3, iDj -> new vGi(Collections.singleton(iDj), (Ukh)iDj));
        }
        if ((iDj2 = AutoDragAndDropTests.firstEmptyScene(dzt4)) != null) {
            this.addDataSource(iDj2, iDj -> new vGi(Collections.singleton(iDj), (Ukh)iDj));
        }
    }

    private void listDataSourcesAndInsertionPointsForTrack(wck wck2) {
        KQz kQz;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(wck2);
        Sfb sfb = wck2.fDY();
        this.listDataSourcesAndInsertionPointsForDeviceChain(sfb);
        KQz kQz2 = AutoDragAndDropTests.firstSlotWithClip(wck2);
        if (kQz2 != null) {
            this.listDataSourcesAndInsertionPointsForSlot(kQz2);
        }
        if ((kQz = AutoDragAndDropTests.firstEmptySlot(wck2)) != null) {
            this.listDataSourcesAndInsertionPointsForSlot(kQz);
        }
    }

    private void listDataSourcesAndInsertionPointsForSlot(KQz kQz2) {
        qgp qgp2 = kQz2.tGl();
        if (qgp2 != null) {
            this.addDataSource(kQz2, kQz -> new vGi(Collections.singletonList(kQz), (Ukh)kQz));
        }
        this.listDataSourcesAndInsertionPointsForSlotOrScene(kQz2);
    }

    private void listDataSourcesAndInsertionPointsForSlotOrScene(Ukh ukh2) {
        this.addInsertionPoint(ukh2, ukh -> new ClipLauncherClipInsertionPoint((Gep)((Object)ukh), ukh.Duz().UUk().jrv()));
    }

    private static KQz firstSlotWithClip(wck wck2) {
        for (KQz kQz : wck2.IIO().uZE()) {
            if (kQz.tGl() == null) continue;
            return kQz;
        }
        return null;
    }

    private static KQz firstEmptySlot(wck wck2) {
        for (KQz kQz : wck2.IIO().uZE()) {
            if (kQz.tGl() != null) continue;
            return kQz;
        }
        return null;
    }

    private static IDj firstSceneWithClips(dzt dzt2) {
        for (IDj iDj : dzt2.mZq()) {
            ArrayList arrayList = new ArrayList();
            iDj.W1d(arrayList);
            if (arrayList.isEmpty()) continue;
            return iDj;
        }
        return null;
    }

    private static IDj firstEmptyScene(dzt dzt2) {
        for (IDj iDj : dzt2.mZq()) {
            ArrayList arrayList = new ArrayList();
            iDj.W1d(arrayList);
            if (!arrayList.isEmpty()) continue;
            return iDj;
        }
        return null;
    }

    private void listDataSourcesAndInsertionPointsForTrackOrTrackGroup(VgJ vgJ2) {
        this.addDataSource(vgJ2, vgJ -> new OZu(Collections.singletonList(vgJ)));
        if (vgJ2.hHY().GvF() > 0) {
            this.addDataSource(vgJ2.hHY().PB(0), cKQ2 -> new JNH(Collections.singleton(cKQ2), (CKQ)cKQ2, cKQ2.w2F() + cKQ2.WPP() / 2.0));
        }
        if (vgJ2.Rtf() != null) {
            this.addInsertionPoint(vgJ2, "Onto", vgJ -> TrackHeaderInsertionPoint.WCG(vgJ, true, vgJ.dY_().UUk().AMf()));
        }
        this.addInsertionPoint(vgJ2, "Time0In", vgJ -> new ArrangerClipInsertionPoint((r2H)((Object)vgJ), 0.0, null, vgJ.dY_().UUk().vvH()));
    }

    private void listDataSourcesAndInsertionPointsForDeviceChain(Sfb sfb2) {
        this.addInsertionPoint(sfb2, "StartOf", sfb -> new DeviceChainInsertionPoint((lUs)((Object)sfb), 0, ((wck)sfb.ocA(wck.class)).UWk().oeT()));
        for (int i2 = 0; i2 < sfb2.DNK(); ++i2) {
            int n2 = i2;
            com.bitwig.flt.document.core.master.device.Pue pue2 = sfb2.W1d(i2);
            this.listDataSourcesAndInsertionPointsForDevice(pue2);
            if (i2 <= 0) continue;
            this.addInsertionPoint(pue2, "Before", pue -> new DeviceChainInsertionPoint(pue.PU1(), n2, pue.h().UWk().oeT()));
        }
        if (sfb2.DNK() > 1) {
            this.addInsertionPoint(sfb2, "EndOf", sfb -> new DeviceChainInsertionPoint((lUs)((Object)sfb), sfb.DNK(), ((wck)sfb.ocA(wck.class)).UWk().oeT()));
            this.addDataSource(sfb2, "AllDevicesIn", sfb -> new com.bitwig.flt.document.core.iface.clipboard.device.htX(sfb.aaP()));
        }
    }

    private void listDataSourcesAndInsertionPointsForDevice(com.bitwig.flt.document.core.master.device.Pue pue2) {
        this.addDataSource(pue2, pue -> new com.bitwig.flt.document.core.iface.clipboard.device.htX(Collections.singletonList(pue)));
        this.addInsertionPoint(pue2, "Onto", pue -> {
            Sfb sfb = pue.PU1();
            int n2 = sfb.WCG((Vbh)((Object)pue));
            wck wck2 = pue.h();
            return new DeviceChainInsertionPoint(sfb, n2, true, true, wck2.UWk().oeT());
        });
    }

    private void addDataSource(I2N i2N, WQ1 wQ1) {
        this.addDataSource(i2N, "", wQ1);
    }

    private void addDataSource(I2N i2N, String string, WQ1 wQ1) {
        com.bitwig.ramona.path.Oxx oxx2 = i2N.tAj();
        String string2 = string + AutoDragAndDropTests.getObjectName(i2N);
        Class<?> clazz = i2N.getClass();
        this.mAllDataSourceCreators.add(new ueo(this, string2, oxx2, clazz, wQ1));
    }

    private void addInsertionPoint(I2N i2N, Oxx oxx2) {
        this.addInsertionPoint(i2N, "", oxx2);
    }

    private void addInsertionPoint(I2N i2N, String string, Oxx oxx2) {
        com.bitwig.ramona.path.Oxx oxx3 = i2N.tAj();
        String string2 = string + AutoDragAndDropTests.getObjectName(i2N);
        Class<?> clazz = i2N.getClass();
        this.mAllInsertionPointCreators.add(new htX(this, string2, oxx3, clazz, oxx2));
    }

    private static String getObjectName(I2N i2N) {
        com.bitwig.ramona.path.Oxx oxx2 = i2N.tAj();
        String string = oxx2.toString();
        String string2 = "track_group/";
        if (string.startsWith("track_group/")) {
            string = string.substring("track_group/".length());
        }
        return nlg.WCG(i2N.Zjp().Eim(), true) + "[" + string.replace('/', ':') + "]";
    }

    static /* synthetic */ List access$000(AutoDragAndDropTests autoDragAndDropTests) {
        return autoDragAndDropTests.mAllDataSourceCreators;
    }

    static /* synthetic */ void access$100(AutoDragAndDropTests autoDragAndDropTests, BoL boL2) {
        autoDragAndDropTests.checkActionIsExpected(boL2);
    }

    static /* synthetic */ int access$200(AutoDragAndDropTests autoDragAndDropTests) {
        return autoDragAndDropTests.mInsertModifiers;
    }
}

