/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.JiN;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestItemSelection;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import java.util.ArrayList;

public class TrackOperationTests
extends BitwigStudioTest {
    @JiN
    public void testTrackGrouping() {
        Object object;
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            object = testProject.WCG(sj3.t3p);
            arrayList.add((TestTrack)object);
        }
        TestItemSelection testItemSelection = testProject.WGS();
        testItemSelection.pqd();
        for (TestTrack testTrack : arrayList) {
            testItemSelection.WCG(testTrack);
        }
        this.check("Created Tracks", testItemSelection.LQe()).WCG(16);
        testItemSelection.BiT();
        object = (TestTrackGroup)this.cast(testProject.BiT().t3p(0), TestTrackGroup.class);
        this.check("Tracks in TrackGroup", ((TestTrackGroup)object).aaP()).WCG(16);
    }

    @JiN
    public void testTrackGroupingAndUngrouping() {
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 24;
        for (int i2 = 0; i2 < 24; ++i2) {
            TestTrack testTrack = testProject.WCG(sj3.t3p);
            arrayList.add(testTrack);
        }
        TestItemSelection testItemSelection = testProject.WGS();
        testItemSelection.pqd();
        for (TestTrack testTrackOrTrackGroup2 : arrayList) {
            testItemSelection.WCG(testTrackOrTrackGroup2);
        }
        this.check("Created Tracks", testItemSelection.LQe()).WCG(24);
        int n3 = testProject.BiT().aaP();
        testItemSelection.BiT();
        TestTrackGroup testTrackGroup = (TestTrackGroup)this.cast(testProject.BiT().t3p(0), TestTrackGroup.class);
        testTrackGroup.pqd();
        testItemSelection.PB();
        int n4 = testProject.BiT().aaP();
        this.check("Tracks Before/After", n3).WCG(n4);
    }

    @JiN
    public void testTrackRename() {
        this.testRenameTrack("Renamed");
    }

    @JiN
    public void testTrackRenameInvalid() {
        String string = new String(new char[]{'\ud800', 'H', 'E', 'L', 'L', 'O'});
        this.testRenameTrack(string);
    }

    @JiN
    public void testDuplicateTrackWithMidiAutomations() {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.WCG(sj3.WCG);
        this.exec(() -> {
            int n2;
            wck wck2 = (wck)testTrack.liD();
            for (int i2 = 0; i2 < 16; ++i2) {
                wck2.WCG(i2, Fgs.WCG, 0);
                wck2.WCG(i2, Fgs.t3p, 0);
                for (n2 = 0; n2 < 128; ++n2) {
                    wck2.WCG(i2, Fgs.W1d, n2);
                }
            }
            ee3 ee32 = wck2.GOR();
            n2 = ee32.YD();
            for (int i4 = 0; i4 < n2; ++i4) {
                qSh qSh2 = ee32.ocA(i4);
                bY bY2 = wck2.t3p((bIV)qSh2);
                JT1 jT1 = bY2.MIw().Zsf();
                jT1.W1d(aHB.WCG(0.0, 0.0));
                jT1.W1d(aHB.WCG(16.0, 127.0));
            }
        });
        testTrack.LQe();
        TestTrack testTrack2 = (TestTrack)testProject.BiT().t3p(1);
        this.check("Duplicated Track Exists", testTrack2).LZT();
        this.check("Automation Lane Count", testTrack2.DNK()).WCG(testTrack.DNK());
        this.exec(() -> {
            wck wck2 = (wck)testTrack2.liD();
            ee3 ee32 = wck2.GOR();
            for (int i2 = 0; i2 < 16; ++i2) {
                this.checkMidiParameterAutomation(wck2, ee32, i2, Fgs.WCG, 0);
                this.checkMidiParameterAutomation(wck2, ee32, i2, Fgs.t3p, 0);
                for (int i4 = 0; i4 < 128; ++i4) {
                    this.checkMidiParameterAutomation(wck2, ee32, i2, Fgs.W1d, i4);
                }
            }
        });
    }

    private void checkMidiParameterAutomation(wck wck2, ee3 ee32, int n2, Fgs fgs, int n3) {
        qSh qSh2 = ee32.t3p(n2, fgs, n3);
        this.check("Has " + fgs.W1d() + "/" + n3 + " Atom on channel " + n2, qSh2).LZT();
        if (qSh2 == null) {
            return;
        }
        bY bY2 = wck2.t3p((bIV)qSh2);
        this.check("Has " + fgs.W1d() + "/" + n3 + " AutomationLane on channel " + n2, bY2).LZT();
    }

    private void testRenameTrack(String string) {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.WCG(sj3.WCG);
        this.check(testTrack.BiT()).pqd();
        this.check(testTrack.PB()).ocA();
        testTrack.t3p(string);
        this.check(testTrack.BiT()).WCG(string);
        this.check(testTrack.PB()).WCG(string);
        this.check(testProject.cUO());
        this.check(!testProject.Zjp());
        testProject.xzw();
        this.check(testTrack.BiT()).pqd();
        this.check(testTrack.PB()).ocA();
        this.check(testProject.Zjp());
        testProject.DNK();
        this.check(testTrack.BiT()).WCG(string);
        this.check(testTrack.PB()).WCG(string);
    }
}

