/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.JiN;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteEvent;
import com.bitwig.flt.app.testing.TestMatrixSlot;
import com.bitwig.flt.app.testing.TestNoteClipEvent;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTimeSignatureEvent;
import com.bitwig.flt.app.testing.TestTimeSignatureTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;

public class SessionRecordingTests
extends BitwigStudioTest {
    @Override
    public int getBlockSize() {
        return 1859;
    }

    @JiN
    public void testRecordingEmptyInstrumentClipToArranger() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.aaP();
        TestTrack testTrack = testProject.WCG(sj3.WCG);
        TestMatrixSlot testMatrixSlot = testTrack.W1d(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.PB(), TestInstrumentNoteClipEvent.class);
        testInstrumentNoteClipEvent.t3p(false);
        TestTransport testTransport = testProject.LQe();
        double d2 = 150.0;
        testTransport.LQe().WCG(150.0);
        testTransport.t3p(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.hFD();
        this.check("clip count", testNoteClipEventTimeline.LQe()).WCG(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.t3p(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.DNK()).WCG(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.BiT()).t3p().t3p(16.0, this.getBlockBeatLength(150.0));
    }

    @JiN
    public void testRecordingTimeSignatureChangesToArranger() {
        TestProject testProject = this.openTestProject("record-time-signature-changes-from-clip-launcher-to-arranger");
        testProject.aaP();
        TestTrack testTrack = testProject.BiT().hFD();
        TestNoteClipEvent testNoteClipEvent = testTrack.W1d(0).BiT();
        testNoteClipEvent.t3p(false);
        TestTransport testTransport = testProject.LQe();
        testTransport.t3p(0.0, 8.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.hFD();
        this.check("clip count", testNoteClipEventTimeline.LQe()).WCG(2);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.t3p(0), TestInstrumentNoteClipEvent.class);
        this.check("clip1 start time", testInstrumentNoteClipEvent.DNK()).WCG(0.0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.t3p(1), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("clip2 start time", testInstrumentNoteClipEvent2.DNK()).WCG(4.0);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testTrack.t3p(testTransport.pqd());
        TestTimeSignatureTimeline testTimeSignatureTimeline = (TestTimeSignatureTimeline)this.cast(testArrangementAutomationTimeline.pqd(), TestTimeSignatureTimeline.class);
        this.check("event count", testTimeSignatureTimeline.LQe()).WCG(2);
        TestTimeSignatureEvent testTimeSignatureEvent = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.W1d(0), TestTimeSignatureEvent.class);
        this.checkBeatTime("time1", testTimeSignatureEvent.DNK()).WCG(0.0);
        this.check("numerator1", testTimeSignatureEvent.LQe()).WCG(4);
        this.check("denominator1", testTimeSignatureEvent.BiT()).WCG(4);
        TestTimeSignatureEvent testTimeSignatureEvent2 = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.W1d(1), TestTimeSignatureEvent.class);
        this.check("time2", testTimeSignatureEvent2.DNK()).WCG(4.0);
        this.check("numerator2", testTimeSignatureEvent2.LQe()).WCG(3);
        this.check("denominator2", testTimeSignatureEvent2.BiT()).WCG(4);
    }

    @JiN
    public void testRecordingClipWithStartMarkerNotAtTimeZero() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.aaP();
        TestTrack testTrack = testProject.WCG(sj3.WCG);
        TestMatrixSlot testMatrixSlot = testTrack.W1d(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.PB(), TestInstrumentNoteClipEvent.class);
        double d2 = 2.75;
        int n2 = 40;
        double d3 = 1.0;
        testInstrumentNoteClipEvent.t3p(2.75);
        testInstrumentNoteClipEvent.WCG(wsc.WCG(2.75, 1.0), 0, 40);
        testInstrumentNoteClipEvent.t3p(false);
        TestTransport testTransport = testProject.LQe();
        double d4 = 150.0;
        testTransport.LQe().WCG(150.0);
        testTransport.t3p(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.hFD();
        this.check("clip count", testNoteClipEventTimeline.LQe()).WCG(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.t3p(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.DNK()).WCG(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.BiT()).t3p().t3p(16.0, this.getBlockBeatLength(150.0));
        this.checkBeatTime("play start in recorded clip", testInstrumentNoteClipEvent2.aaP()).WCG(2.75);
        TestNoteEventTimeline testNoteEventTimeline = testInstrumentNoteClipEvent2.LZT().WCG(40, 0);
        int n3 = testNoteEventTimeline.LQe();
        this.check("recorded note count", n3).WCG(1);
        TestInstrumentNoteEvent testInstrumentNoteEvent = (TestInstrumentNoteEvent)this.cast(testNoteEventTimeline.t3p(0), TestInstrumentNoteEvent.class);
        this.check("recorded note start time", testInstrumentNoteEvent.DNK()).WCG(2.75);
        this.check("recorded note duration", testInstrumentNoteEvent.BiT()).WCG(1.0);
    }
}

