/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.hJP;
import com.bitwig.base.testing.JiN;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAnalyzedAudioFile;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.flt.sample_analysis.DbT;
import com.bitwig.flt.sample_analysis.FIg;
import com.bitwig.flt.sample_analysis.OZu;
import com.bitwig.flt.sample_analysis.gMo;
import com.bitwig.flt.sample_analysis.ueo;
import java.io.File;
import java.io.IOException;

public class OnsetAnalysisTests
extends BitwigStudioTestDataFileTest {
    @Override
    protected String getTopLevelDirectoryPath() {
        return "audio-file-analysis";
    }

    @Override
    protected boolean shouldCreateTestForFileType(ouY ouY2) {
        return ouY2 instanceof wUM;
    }

    @JiN
    public void testBitwigVampPluginHostOnsetAnalyzer() {
        ueo ueo2 = this.getApplication().HWW();
        this.check(ueo2).LZT();
        File file = ueo2.BiT();
        this.check(file).t3p();
        File file2 = this.getFile().AhM();
        File file3 = this.getOutputFile("detected.onsets");
        FIg fIg = new FIg(file, file3);
        fIg.WCG(file2);
        this.check(file3).pqd();
        File file4 = this.getExpectedFile("onsets").AhM();
        gMo.WCG(file4);
        this.checkOnsetsAreCorrect(file3, file4);
    }

    @JiN
    public void testOnsetAnalysisViaCache() {
        ueo ueo2 = this.getApplication().HWW();
        this.check(ueo2).LZT();
        File file = this.getFile().AhM();
        OZu oZu = ueo2.WCG(new hJP(file));
        this.check(oZu).LZT();
        File file2 = ueo2.BiT();
        this.check(file2).t3p();
        TestAnalyzedAudioFile testAnalyzedAudioFile = new TestAnalyzedAudioFile((BitwigStudioTest)this, oZu);
        DbT dbT = testAnalyzedAudioFile.WCG(file, file2);
        this.check(file2).t3p();
        File file3 = oZu.WCG(file2);
        this.check(dbT).LZT();
        int n2 = dbT.WCG();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = dbT.WCG(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = dbT.t3p(i2);
            this.check(d4).WCG(0.0, 2.0);
            d2 = d3;
        }
        File file4 = this.getExpectedFile("onsets").AhM();
        this.checkOnsetsAreCorrect(file3, file4);
    }

    private void checkOnsetsAreCorrect(File file, File file2) {
        this.check("onsets correct", file).WCG(file2, () -> {
            DbT dbT = this.loadOnsets(file);
            this.check(file2).pqd();
            DbT dbT2 = this.loadOnsets(file2);
            this.check("onset count", dbT.WCG()).WCG(dbT2.WCG());
            int n2 = dbT.WCG();
            this.check(n2 > 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2;
                double d3 = dbT.WCG(i2);
                double d4 = Math.abs(d3 - (d2 = dbT2.WCG(i2)));
                this.check(d4 < 1.0E-4);
            }
        });
    }

    private DbT loadOnsets(File file) {
        DbT dbT = null;
        try {
            dbT = gMo.WCG(file);
        }
        catch (IOException iOException) {
            this.fail("load onsets file " + file.getAbsolutePath(), iOException);
        }
        this.check(dbT).LZT();
        int n2 = dbT.WCG();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = dbT.WCG(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = dbT.t3p(i2);
            this.check(d4).WCG(0.0, 2.0);
            d2 = d3;
        }
        return dbT;
    }
}

