/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.JiN;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestChainSelector;
import com.bitwig.flt.app.testing.TestChainSelectorIndexedValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestIndexedValueAtom;
import com.bitwig.flt.app.testing.TestIndexedValueType;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestNestedDeviceChain;
import com.bitwig.flt.app.testing.TestPermanentAutomationLane;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.luf;
import com.bitwig.flt.document.core.master.device.te;
import java.util.UUID;

public abstract class ChainSelectorTests
extends BitwigStudioTest {
    protected abstract UUID getDeviceId();

    protected abstract sj3 getTrackType();

    private TestChainSelector createAndGetChainSelector() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        return (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
    }

    @JiN
    public void checkAddDeleteSimple() {
        TestChainSelector testChainSelector = this.createAndGetChainSelector();
        this.check("ChainSelectorEmpty", testChainSelector.BiT()).WCG(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.pqd().LQe()).WCG(0);
        testChainSelector.LQe();
        this.check("ChainSelectorEmpty", testChainSelector.BiT()).WCG(1);
        this.check("SelectedIndexWhileEmpty", testChainSelector.pqd().LQe()).WCG(0);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.t3p(0);
        testNestedDeviceChain.ocA();
        this.check("ChainSelectorEmpty", testChainSelector.BiT()).WCG(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.pqd().LQe()).WCG(0);
    }

    @JiN
    public void checkAddDeleteComplex() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.LQe();
            this.check("chainCount", testChainSelector.BiT()).WCG(i2 + 1);
            String string = "Test Chain " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain = testChainSelector.t3p(i2);
            testNestedDeviceChain.t3p(string);
            this.check("title", testNestedDeviceChain.BiT()).WCG(string);
            this.check("displayedTitle", testNestedDeviceChain.PB()).WCG(string);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.pqd();
        this.check("indexInit", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelector.LQe();
        this.check("indexAfterAddChain", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        this.check("chainCount", testChainSelector.BiT()).WCG(6);
        testChainSelector.t3p(0).ocA();
        this.check("indexAfterRemoveChain", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        this.check("chainCount", testChainSelector.BiT()).WCG(5);
        testChainSelector.t3p(1).ocA();
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        this.check("chainCount", testChainSelector.BiT()).WCG(4);
        testChainSelectorIndexedValueAtom.t3p(2);
        testChainSelector.t3p(0).ocA();
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        this.check("chainCount", testChainSelector.BiT()).WCG(3);
        testChainSelectorIndexedValueAtom.t3p(2);
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        testChainSelector.t3p(2).ocA();
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        this.check("chainCount", testChainSelector.BiT()).WCG(2);
    }

    @JiN
    public void checkMoveToFirst() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.LQe();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.pqd();
        testChainSelectorIndexedValueAtom.t3p(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.t3p(0);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.t3p(2);
        testNestedDeviceChain.WGS().WCG(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.BiT()).WCG(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).WCG(testChainSelector.t3p(0));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).WCG(testChainSelector.t3p(1));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
    }

    public void checkMoveToLast() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.LQe();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.pqd();
        testChainSelectorIndexedValueAtom.t3p(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.t3p(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.t3p(2);
        testNestedDeviceChain.hFD().WCG(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.BiT()).WCG(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).WCG(testChainSelector.t3p(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).WCG(testChainSelector.t3p(3));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.LQe()).WCG(4);
    }

    @JiN
    public void checkDuplicate() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.LQe();
        }
        testTrack.pqd().LZT();
    }

    @JiN
    public void checkPrevNextArrows() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.pqd();
        this.check("index when empty", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index when empty after selectNextValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index when empty after selectPrevValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index when empty after cycleNextValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index when empty after cyclePrevValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelector.LQe();
        this.check("index with a single chain", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index with a single chain after selectNextValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index with a single chain after selectPrevValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index with a single chain after cycleNextValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index with a single chain after cyclePrevValue()", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelector.LQe();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index next at end", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index prev", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelector.LQe();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        testChainSelectorIndexedValueAtom.BiT();
        this.check("index next at end", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index prev", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index prev", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.PB();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        testChainSelectorIndexedValueAtom.LZT();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(2);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(1);
        testChainSelectorIndexedValueAtom.aaP();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
    }

    @JiN
    public void checkAutomation() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.LQe();
        }
        this.check("chainCount", testChainSelector.BiT()).WCG(5);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.pqd();
        TestIndexedValueType testIndexedValueType = testChainSelectorIndexedValueAtom.pqd();
        this.check("indexValueTypeIsAutomatable", testIndexedValueType.pqd());
        this.check("indexValueTypeIsInterpolated", !testIndexedValueType.LQe());
        testChainSelectorIndexedValueAtom.hFD();
        TestPermanentAutomationLane testPermanentAutomationLane = testTrack.WCG(testChainSelectorIndexedValueAtom);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.t3p(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.t3p(2);
        testNestedDeviceChain.hFD().WCG(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.BiT()).WCG(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).WCG(testChainSelector.t3p(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).WCG(testChainSelector.t3p(3));
    }

    @JiN
    public void checkMoveBetweenTwoDevices() {
        Object object;
        TestNestedDeviceChain testNestedDeviceChain;
        Object object2;
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.WCG(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.LZT();
        TestNativeDevice testNativeDevice = testDeviceChain.WCG(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.WCG(te.class), TestChainSelector.class);
        TestNativeDevice testNativeDevice2 = testDeviceChain.WCG(1, this.getDeviceId());
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.WCG(te.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.LQe();
            testChainSelector2.LQe();
            this.check("chainCount1", testChainSelector.BiT()).WCG(i2 + 1);
            this.check("chainCount2", testChainSelector2.BiT()).WCG(i2 + 1);
            object2 = "Test Chain1 " + (i2 + 1);
            testNestedDeviceChain = testChainSelector.t3p(i2);
            testNestedDeviceChain.t3p((String)object2);
            this.check("title", testNestedDeviceChain.BiT()).WCG((String)object2);
            this.check("displayedTitle", testNestedDeviceChain.PB()).WCG((String)object2);
            object = "Test Chain2 " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector2.t3p(i2);
            testNestedDeviceChain2.t3p((String)object);
            this.check("title", testNestedDeviceChain2.BiT()).WCG((String)object);
            this.check("displayedTitle", testNestedDeviceChain2.PB()).WCG((String)object);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.pqd();
        this.check("indexInit1", testChainSelectorIndexedValueAtom.LQe()).WCG(0);
        object2 = testChainSelector2.pqd();
        this.check("indexInit2", ((TestIndexedValueAtom)object2).LQe()).WCG(0);
        testChainSelectorIndexedValueAtom.t3p(2);
        ((TestIndexedValueAtom)object2).t3p(2);
        testNestedDeviceChain = testChainSelector.t3p(2);
        object = testChainSelector2.t3p(2);
        testNestedDeviceChain.hFD().WCG((luf)object);
        this.check("index1", testChainSelector.pqd().LQe()).WCG(2);
        this.check("chainsCount1", testChainSelector.BiT()).WCG(6);
        this.check("index2", testChainSelector2.pqd().LQe()).WCG(2);
        this.check("chainsCount2", testChainSelector2.BiT()).WCG(4);
    }
}

