/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioSource;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.fX;
import com.bitwig.flt.app.testing.tests.AudioRecordingOrBouncingTests;
import com.bitwig.flt.app.testing.tests.kK;
import java.io.File;
import java.util.Collection;

public abstract class BounceTests
extends AudioRecordingOrBouncingTests {
    private MQi mSampleBitDepth;
    private Boolean mShouldBounceInRealtime;

    @Override
    public String getTestName() {
        if (this.mShouldBounceInRealtime != null) {
            if (this.mSampleBitDepth == null) {
                return this.mShouldBounceInRealtime != false ? "realtime" : "offline";
            }
        } else {
            return this.getClass().getSimpleName();
        }
        return super.getTestName();
    }

    @Override
    protected String getMethodNodeName() {
        return this.mSampleBitDepth.W1d();
    }

    @Override
    protected void listChildren(Collection collection) {
        if (this.mShouldBounceInRealtime == null) {
            BounceTests bounceTests = (BounceTests)this.createChild();
            bounceTests.mShouldBounceInRealtime = Boolean.FALSE;
            collection.add(bounceTests);
            BounceTests bounceTests2 = (BounceTests)this.createChild();
            bounceTests2.mShouldBounceInRealtime = Boolean.TRUE;
            collection.add(bounceTests2);
        } else if (this.mSampleBitDepth == null) {
            for (MQi mQi : MQi.values()) {
                BounceTests bounceTests = (BounceTests)this.createChild();
                bounceTests.mSampleBitDepth = mQi;
                collection.add(bounceTests);
            }
        } else {
            super.listChildren(collection);
        }
    }

    @Override
    protected TestAudioNoteClipEvent recordClip(TestProject testProject, TestTrack testTrack, double d2, double d3, kK kK2) {
        File file = this.getExpectedRecordedFile();
        file.delete();
        TestAudioSource testAudioSource = testTrack.Zjp();
        gKv gKv2 = (gKv)this.get(() -> this.createBounceRequest((uby)testAudioSource.liD(), d2, d3, file));
        gKv2.WCG(kK2.ordinal());
        try {
            TestAudioNoteClipEvent testAudioNoteClipEvent = testAudioSource.WCG(gKv2, this.mSampleBitDepth, this.mShouldBounceInRealtime);
            if (kK2 != kK.WCG) {
                this.fail("Should have reported error bouncing");
            }
            return testAudioNoteClipEvent;
        }
        catch (fX fX2) {
            if (kK2 == kK.WCG) {
                throw fX2;
            }
            return fX2.WCG();
        }
    }

    protected abstract gKv createBounceRequest(uby var1, double var2, double var4, File var6);

    @Override
    protected File getExpectedRecordedFile() {
        return this.getOutputFile(this.mSampleBitDepth + (this.mShouldBounceInRealtime != false ? "-realtime" : "") + ".wav", false);
    }

    @Override
    protected int getExpectedBitsPerSample() {
        switch (this.mSampleBitDepth) {
            case W1d: {
                return 32;
            }
            case WCG: {
                return 16;
            }
            case t3p: {
                return 24;
            }
        }
        this.fail("Unknown sample bit depeth");
        return 0;
    }

    @Override
    protected Class getErrorNotificationType() {
        return HRA.class;
    }
}

