/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.hJP;
import com.bitwig.base.testing.JiN;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTempoAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.kK;
import java.io.File;

public abstract class AudioRecordingOrBouncingTests
extends BitwigStudioTest {
    @JiN
    public void testRecordingAudio() {
        this.testRecordingAudio(0.0, 4.0, 120.0);
    }

    @JiN
    public void testRecordingShortAudio() {
        double d2 = 120.0;
        this.testRecordingAudio(0.0, prQ.WCG(this.getBlockBeatLength(120.0) * 2.0), 120.0);
    }

    private void testRecordingAudio(double d2, double d3, double d4) {
        this.checkBeatTime(d2).t3p().pqd(0.0);
        this.checkBeatTime("record duration", d3).t3p().W1d(0.0);
        TestProject testProject = this.createTestProject(1, 0);
        testProject.aaP();
        TestTransport testTransport = testProject.LQe();
        testTransport.LQe().WCG(d4);
        TestTrack testTrack = testProject.WCG(sj3.t3p);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, d2, d3, kK.WCG);
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, d3, this.getExpectedDurationInBeatsTolerance(d4), this.getExpectedRecordedFile(), kK.WCG);
    }

    protected File getExpectedRecordedFile() {
        return null;
    }

    @JiN
    public void testRecordingAudioWithIOErrorOnOpen() {
        this.testRecordingAudioWithError(kK.t3p);
    }

    @JiN
    public void testRecordingAudioWithIOErrorOnWrite() {
        this.testRecordingAudioWithError(kK.W1d);
    }

    @JiN
    public void testRecordingAudioWithIOErrorOnClose() {
        this.testRecordingAudioWithError(kK.pqd);
    }

    private void testRecordingAudioWithError(kK kK2) {
        double d2;
        double d3;
        this.check(kK2 != kK.WCG);
        this.check("no error with recording audio so far", this.getFirstNotificationOfType(this.getErrorNotificationType())).PB();
        TestProject testProject = this.createTestProject(1, 0);
        testProject.aaP();
        double d4 = testProject.LQe().LQe().pqd();
        TestTrack testTrack = testProject.WCG(sj3.t3p);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 4.0, kK2);
        if (kK2 == kK.t3p || kK2 == kK.W1d) {
            d3 = 0.0;
            d2 = 0.0;
        } else {
            d3 = 0.0;
            d2 = 0.0;
        }
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, 4.0, this.getExpectedDurationInBeatsTolerance(d4), d3, d2, this.getExpectedRecordedFile(), kK2);
        this.check("error notification was shown", this.getFirstNotificationOfType(this.getErrorNotificationType())).LZT();
    }

    @JiN
    public void testRecordingAudioWithTempoAutomation() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.aaP();
        TestTransport testTransport = testProject.LQe();
        testTransport.LQe().hFD();
        TestTrack testTrack = testProject.WCG(sj3.t3p);
        TestTempoAutomationEventTimeline testTempoAutomationEventTimeline = (TestTempoAutomationEventTimeline)this.cast(testProject.BiT().hFD().t3p(testTransport.LQe()).pqd(), TestTempoAutomationEventTimeline.class);
        double d2 = 120.0;
        int n2 = 24;
        double d3 = 200.0;
        int n3 = 8;
        int n4 = 16;
        int n5 = 4;
        testTempoAutomationEventTimeline.WCG(0.0, 120.0);
        testTempoAutomationEventTimeline.WCG(8.0, 200.0);
        testTempoAutomationEventTimeline.WCG(16.0, 200.0);
        testTempoAutomationEventTimeline.WCG(24.0, 120.0);
        int n6 = 66;
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 24.0, kK.WCG);
        this.check("recorded clip", testAudioNoteClipEvent).LZT();
        this.check("start time", testAudioNoteClipEvent.DNK()).WCG(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.WCG(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.LQe()).WCG(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.t3p(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.DNK()).WCG(0.0);
        this.check(!testAudioNoteEvent.xzw());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.LQe();
        this.check("warp event count", testWarpEventTimeline.LQe()).WCG(66);
        TestSampleReference testSampleReference = testAudioNoteEvent.pqd();
        testSampleReference.BiT();
        double d4 = testSampleReference.PB();
        double d5 = 24.0;
        this.check(!testSampleReference.LQe());
        String string = testSampleReference.pqd().pqd().pqd();
        File file = new File(string);
        this.check("recorded file", file).pqd().BiT().t3p(0L);
        bym bym2 = bym.t3p(GYl.W1d(file));
        double d6 = bym2.Zjp();
        this.check("file duration", d6).t3p(d4, 7.0);
        byn byn2 = bym2.tzx();
        this.check("metadata chunk", byn2).LZT();
        byk byk2 = byn2.WCG();
        this.check("warp markers", byk2).LZT();
        int n7 = byk2.W1d();
        this.check("warp marker count", n7).WCG(66);
        for (int i2 = 0; i2 < 32; ++i2) {
            double d7 = (double)i2 / 4.0;
            double d8 = testProject.WCG(d7);
            this.checkWarpMarkerWithTempoAutomation(i2, byk2, testWarpEventTimeline, d7, d8);
        }
        this.checkWarpMarkerWithTempoAutomation(n7 - 1, byk2, testWarpEventTimeline, 24.0, d6);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, byk2);
    }

    private void checkWarpMarkerWithTempoAutomation(int n2, byk byk2, TestWarpEventTimeline testWarpEventTimeline, double d2, double d3) {
        byj byj2 = byk2.WCG(n2);
        double d4 = byj2.t3p();
        this.check("warp marker beat time " + n2, d4).WCG(d2, 3);
        if (n2 > 0 && n2 < byk2.W1d() - 1) {
            this.checkBeatTime("warp marker " + n2 + " beat time", d4).W1d();
        }
        this.check("warp marker sample time " + n2, byj2.WCG()).WCG(d3, 1);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.t3p(n2), TestWarpEvent.class);
        double d5 = testWarpEvent.DNK();
        this.checkBeatTime("warp event beat time " + n2, d5).t3p();
        if (n2 > 0 && n2 < byk2.W1d() - 1) {
            this.checkBeatTime("warp event beat time " + n2, d4).W1d();
        }
        this.check("warp event sample time " + n2, testWarpEvent.pqd()).WCG(byj2.WCG());
    }

    protected abstract TestAudioNoteClipEvent recordClip(TestProject var1, TestTrack var2, double var3, double var5, kK var7);

    protected double getExpectedDurationInBeatsTolerance(double d2) {
        return 0.0;
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, File file, kK kK2) {
        double d5 = d3 / d2 * 60.0;
        double d6 = d4 != 0.0 ? d4 / d2 * 60.0 : 1.0 / (double)this.getSampleRate();
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d2, d3, d4, d5, d6, file, kK2);
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, double d5, double d6, File file, kK kK2) {
        this.check("clip", testAudioNoteClipEvent).LZT();
        this.check("start time", testAudioNoteClipEvent.DNK()).WCG(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.WCG(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.LQe()).WCG(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.t3p(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.DNK()).WCG(0.0);
        this.check(!testAudioNoteEvent.xzw());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.LQe();
        int n2 = testWarpEventTimeline.LQe();
        this.check("warp event count", n2).WCG(2);
        TestSampleReference testSampleReference = testAudioNoteEvent.pqd();
        testSampleReference.BiT();
        double d7 = testSampleReference.PB();
        if (kK2 == kK.WCG) {
            this.check("sample ref duration", d7).t3p(d5, d6);
        }
        double d8 = testAudioNoteClipEvent.BiT();
        this.checkBeatTime("clip duration", d8).t3p().t3p(d3, d4);
        this.check("event duration", testAudioNoteEvent.BiT()).WCG(d8);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.t3p(0), TestWarpEvent.class);
        this.check("first warp event time", testWarpEvent.DNK()).WCG(0.0);
        this.check("first warp event sample time", testWarpEvent.pqd()).WCG(0.0);
        TestWarpEvent testWarpEvent2 = (TestWarpEvent)this.cast(testWarpEventTimeline.t3p(n2 - 1), TestWarpEvent.class);
        this.check("last warp event time", testWarpEvent2.DNK()).WCG(d8);
        if (kK2 == kK.WCG) {
            this.check("last warp event sample time", testWarpEvent2.pqd()).WCG(d7);
        }
        this.check(!testSampleReference.LQe());
        String string = testSampleReference.pqd().pqd().pqd();
        File file2 = new File(string);
        if (file != null) {
            this.check(file.getPath()).WCG(file2.getPath());
        }
        if (kK2 == kK.WCG) {
            this.checkAudioFile(file2, d7, d8);
        }
    }

    protected void checkAudioFile(File file, double d2, double d3) {
        this.check("file", file).pqd().BiT().t3p(0L);
        bym bym2 = bym.t3p(GYl.W1d(file));
        this.check("sample rate correct", bym2.cUO()).WCG(this.getSampleRate());
        this.check("channel count correct", bym2.xzw()).WCG(2);
        this.check("bit depth correct", bym2.DNK()).WCG(this.getExpectedBitsPerSample());
        double d4 = bym2.Zjp();
        this.check("file duration", d4).t3p(d2, 7.0);
        byn byn2 = bym2.tzx();
        this.check("metadata chunk", byn2).LZT();
        byk byk2 = byn2.WCG();
        this.check("warp markers", byk2).LZT();
        int n2 = byk2.W1d();
        this.check("warp marker count", n2).WCG(2).ocA(2);
        byj byj2 = byk2.WCG(0);
        this.check("first warp marker beat time", byj2.t3p()).WCG(0.0);
        this.check("first warp marker sample time", byj2.WCG()).WCG(0.0);
        byj byj3 = byk2.WCG(n2 - 1);
        this.checkBeatTime("last warp marker beat time", byj3.t3p()).ocA(d3);
        this.check("last warp marker sample time", byj3.WCG()).WCG(d4);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, byk2);
    }

    private void checkLoadingAudioNoteHasExpectedWarpMarkers(File file, byk byk2) {
        nwG nwG2 = new nwG(new hJP(file));
        int n2 = 60;
        nwG2.WCG(60.0, true);
        byk byk3 = nwG2.pqd();
        this.check("loaded sample info has warp markers", byk3).LZT();
        this.checkHasSameWarpMarkers(byk2, byk3);
        IQ iQ2 = IQ.WCG(nwG2, BXc.t3p, 60.0);
        qRy qRy2 = iQ2.Duz().YEX();
        this.checkWarpEventsAreCorrectForWarpMarkers(qRy2, byk2);
    }

    private void checkHasSameWarpMarkers(byk byk2, byk byk3) {
        this.check(byk2.W1d()).t3p(byk3.W1d());
        for (int i2 = 0; i2 < byk2.W1d(); ++i2) {
            byj byj2 = byk2.WCG(i2);
            byj byj3 = byk3.WCG(i2);
            this.check("Warp marker " + (i2 + 1) + " is the same", byj2).WCG(byj3);
        }
    }

    private void checkWarpEventsAreCorrectForWarpMarkers(qRy qRy2, byk byk2) {
        int n2 = qRy2.GvF();
        int n3 = byk2.W1d();
        this.check("warp event count is correct", n2).WCG(n3);
        for (int i2 = 0; i2 < Math.min(n3, n2); ++i2) {
            byj byj2 = byk2.WCG(i2);
            AFc aFc2 = qRy2.t3p(i2);
            this.check("Warp event " + (i2 + 1) + " beat time is correct", aFc2.w2F()).WCG(prQ.WCG(byj2.t3p()));
            this.check("Warp event " + (i2 + 1) + " sample time is correct", aFc2.ocA()).WCG(byj2.WCG());
        }
    }

    protected abstract int getExpectedBitsPerSample();

    protected abstract Class getErrorNotificationType();
}

