/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing;

import com.bitwig.base.io.luf;
import com.bitwig.base.testing.AnnotationBasedTest;
import com.bitwig.flt.app.testing.BoL;
import com.bitwig.flt.app.testing.SLv;
import com.bitwig.flt.app.testing.TestPackageManager;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.VYg;
import com.bitwig.flt.app.testing.qXT;
import com.bitwig.flt.app.testing.te;
import com.bitwig.flt.app.testing.ueo;
import com.bitwig.flt.app.testing.vzv;
import com.bitwig.ramona.core.Enr;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class BitwigStudioTest
extends AnnotationBasedTest {
    private static final int DEFAULT_OPEN_PROJECT_TIMEOUT = 30;
    private int mEngineAssertFileCount = 0;

    @Override
    protected void beforeRun() {
        super.beforeRun();
        this.mEngineAssertFileCount = 0;
    }

    @Override
    protected void afterRun() {
        super.afterRun();
        this.addEngineAssertions();
    }

    public int getSampleRate() {
        return 44100;
    }

    public int getBlockSize() {
        return 512;
    }

    private void addEngineAssertions() {
        int n2 = this.mEngineAssertFileCount;
        if (n2 == 0) {
            return;
        }
        sih sih2 = new sih();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.getEngineAssertsFile(i2, false);
            try {
                sih2.WCG((File)object);
                continue;
            }
            catch (IOException iOException) {
                LOG.pqd("Error parsing engine assertions file " + object, iOException);
            }
        }
        for (Object object : sih2.WCG()) {
            this.addCheck(new cIb("Engine", ((Mwg)object).WCG(), ((Mwg)object).t3p(), ((Mwg)object).W1d(), ((Mwg)object).pqd(), ((Mwg)object).ocA()));
        }
    }

    @Override
    public String getObjectAsString(Object object) {
        if (object instanceof Enr) {
            Enr enr = (Enr)object;
            return (String)this.get(enr::toString);
        }
        return super.getObjectAsString(object);
    }

    public ueo checkBeatTime(double d2) {
        return new ueo(this, d2);
    }

    public ueo checkBeatTime(String string, double d2) {
        return new ueo(this, d2, string);
    }

    protected VYg getApplication() {
        return (VYg)this.getEventProcessor();
    }

    protected File getOutputFile(String string) {
        return this.getOutputFile(string, true);
    }

    protected File getOutputFile(String string, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("test-output");
        stringBuilder.append('/');
        BitwigStudioTest.appendTestPathAsFilePath(this, stringBuilder);
        stringBuilder.append('/');
        stringBuilder.append(string);
        File file = this.getTestDataFile(stringBuilder.toString(), false).FI();
        if (bl2 && file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private static void appendTestPathAsFilePath(com.bitwig.base.testing.BoL boL2, StringBuilder stringBuilder) {
        com.bitwig.base.testing.BoL boL3 = boL2.getParent();
        if (boL3 != null) {
            BitwigStudioTest.appendTestPathAsFilePath(boL3, stringBuilder);
            stringBuilder.append('/');
        }
        stringBuilder.append(luf.PB(boL2.getTestName()));
    }

    private Sve createProject(int n2, int n3) {
        return (Sve)this.get(() -> this.doCreateProject(n2, n3));
    }

    protected TestProject createTestProject(int n2, int n3) {
        TestProject testProject = new TestProject(this, this.createProject(n2, n3));
        this.openedProject(testProject);
        return testProject;
    }

    protected TestProject createTestProject() {
        return this.createTestProject(0, 0);
    }

    protected void openedProject(TestProject testProject) {
        SLv sLv = this.getTestRunnerService();
        if (sLv.UaU().t3p()) {
            testProject.aaP();
        }
    }

    private Sve doCreateProject(int n2, int n3) {
        assert (bhd.t3p(this.isEventDispatchThread()));
        vzv vzv2 = new vzv(this);
        return this.getApplication().WCG(n2, n3, vzv2);
    }

    protected TestProject openTestProject(String string) {
        return this.openTestProject(string, 30);
    }

    protected TestProject openTestProject(String string, int n2) {
        return this.openTestProject(this.getTestProjectFile(string), n2);
    }

    protected File getTestProjectFile(String string) {
        return this.getTestDataFile("test-data/projects/" + string + "/" + string + ".bwproject").AhM();
    }

    protected TestProject openTestProject(GYl gYl) {
        return this.openTestProject(gYl.AhM());
    }

    protected TestProject openTestProject(File file) {
        return this.openTestProject(file, 30);
    }

    protected TestProject openTestProject(File file, int n2) {
        TestProject testProject = new TestProject(this, this.openProject(file, n2));
        this.openedProject(testProject);
        return testProject;
    }

    private Sve openProject(File file, int n2) {
        this.check(this.isTestRunnerThread());
        this.check(file).ocA();
        VYg vYg2 = this.getApplication();
        lgj lgj2 = new lgj();
        vzv vzv2 = new vzv(this);
        this.asyncExec(() -> vYg2.WCG(file, vzv2, lgj2));
        return (Sve)this.waitForAsyncTask("Open project " + file.getName(), lgj2, (long)n2, TimeUnit.SECONDS);
    }

    protected void compareWavFiles(File file, File file2, fE fE3) {
        this.check("output", file).WCG(file2, () -> {
            Throwable throwable;
            cWJ cWJ2;
            Object object;
            Object object2;
            long l2 = 0L;
            this.check(file).pqd();
            this.check(file2).pqd();
            if (file.isFile() && file2.isFile()) {
                try {
                    object2 = cWJ.WCG(file);
                    object = null;
                    try {
                        cWJ2 = cWJ.WCG(file2);
                        throwable = null;
                        try {
                            l2 = ((cWJ)object2).t3p();
                            this.check("numFrames", ((cWJ)object2).t3p()).WCG(cWJ2.t3p());
                            this.check("numChannels", ((cWJ)object2).WCG()).WCG(cWJ2.WCG());
                            this.check("sampleRate", ((cWJ)object2).W1d()).WCG(cWJ2.W1d());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (cWJ2 != null) {
                                if (throwable != null) {
                                    try {
                                        cWJ2.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    cWJ2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        object = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((cWJ)object2).close();
                                }
                                catch (Throwable throwable5) {
                                    ((Throwable)object).addSuppressed(throwable5);
                                }
                            } else {
                                ((cWJ)object2).close();
                            }
                        }
                    }
                }
                catch (cWL | IOException exception) {
                    this.fail(exception);
                }
            }
            object2 = new CNp();
            object = luf.pqd(file.getAbsolutePath()) + ".diff.wav";
            try {
                cWJ2 = cWJ.WCG(new File((String)object), 2, l2, 24, 44100L);
                throwable = null;
                try {
                    boolean bl2 = s2o.WCG(file2, file, (pie)object2, cWJ2);
                    this.check("compareWaveFiles", bl2);
                    if (bl2) {
                        double d2 = 0.0;
                        double d3 = fE3 == fE.WCG ? -90.0 : 0.0;
                        double d4 = -24.0;
                        this.addDecibelCheck("Exact", ((CNp)object2).WCG(), 0.0);
                        this.addDecibelCheck("Shift One", ((CNp)object2).t3p(), d3);
                        this.addDecibelCheck("Moving Average", ((CNp)object2).W1d(), -24.0);
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (cWJ2 != null) {
                        if (throwable != null) {
                            try {
                                cWJ2.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            cWJ2.close();
                        }
                    }
                }
            }
            catch (cWL | IOException exception) {
                this.fail(exception);
            }
        });
    }

    protected void addDecibelCheck(String string, double d2, double d3) {
        double d4 = Us.pqd(d2);
        this.addCheck(string, d4 < d3, this.formatDecibels(d4), "below " + this.formatDecibels(d3), false);
    }

    protected String formatDecibels(double d2) {
        if (d2 < -160.0) {
            return "-\u221e";
        }
        return Integer.toString((int)d2);
    }

    public TestPackageManager getPackageManager() {
        return (TestPackageManager)this.getTestObject(this.getApplication()::WPP, TestPackageManager.class);
    }

    protected qXT getTestObject(Supplier supplier) {
        qXT qXT2 = this.getOptTestObject(supplier);
        this.check(qXT2).LZT();
        return qXT2;
    }

    protected qXT getTestObject(Supplier supplier, Class clazz) {
        qXT qXT2 = this.getTestObject(supplier);
        return (qXT)this.cast(qXT2, clazz);
    }

    protected qXT getOptTestObject(Supplier supplier, Class clazz) {
        qXT qXT2 = this.getOptTestObject(supplier);
        if (qXT2 == null) {
            return null;
        }
        return (qXT)this.cast(qXT2, clazz);
    }

    protected qXT getOptTestObject(Supplier supplier) {
        Object object = this.getOpt(supplier);
        if (object == null) {
            return null;
        }
        return te.WCG(this, object);
    }

    public qXT createTestObject(Object object) {
        return te.WCG(this, object);
    }

    public qXT createTestObject(Object object, Class clazz) {
        qXT qXT2 = te.WCG(this, object);
        return (qXT)this.cast(qXT2, clazz);
    }

    @Override
    public BoL getTestRunner() {
        return (BoL)super.getTestRunner();
    }

    public SLv getTestRunnerService() {
        BoL boL2 = this.getTestRunner();
        if (boL2 == null) {
            return null;
        }
        return (SLv)boL2.t3p().WCG();
    }

    public File getEngineLogFile() {
        return this.getOutputFile("engine.log", false);
    }

    public final File getNextEngineAssertsFile() {
        assert (bhd.t3p(this.isEventDispatchThread()));
        ++this.mEngineAssertFileCount;
        return this.getEngineAssertsFile(this.mEngineAssertFileCount - 1, true);
    }

    public final int getEngineAssertsFileCount() {
        return this.mEngineAssertFileCount;
    }

    public File getEngineAssertsFile(int n2, boolean bl2) {
        return this.getOutputFile("engine-asserts" + (n2 + 1) + ".txt", bl2);
    }

    @Override
    protected com.bitwig.base.testing.BoL createChild() {
        BitwigStudioTest bitwigStudioTest = (BitwigStudioTest)super.createChild();
        bitwigStudioTest.mEngineAssertFileCount = 0;
        return bitwigStudioTest;
    }

    public double getSampleBeatLength(double d2) {
        double d3 = d2 / 60.0;
        int n2 = this.getSampleRate();
        double d4 = 1.0 / (double)n2;
        return d4 * d3;
    }

    public double getBlockBeatLength(double d2) {
        return this.getSampleBeatLength(d2) * (double)this.getBlockSize();
    }

    public double getBlockDurationInSeconds() {
        return (double)this.getBlockSize() / (double)this.getSampleRate();
    }

    public Hfd getFirstNotificationOfType(Class clazz) {
        return (Hfd)this.getOpt(() -> (Hfd)this.getApplication().n_().WCG(clazz));
    }
}

