/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.platform;

import com.bitwig.base.io.ProcessException;
import com.bitwig.base.io.lgj;
import com.bitwig.base.io.luf;
import com.bitwig.base.io.noL;
import com.bitwig.base.io.oie;
import com.bitwig.base.platform.MacOsXIoKit;
import com.bitwig.base.platform.WindowsPlatform;
import com.bitwig.base.platform.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;

public final class Platform {
    private static String t3p;
    private static UUID W1d;
    private static boolean pqd;
    private static File ocA;
    private static File LQe;

    public static void WCG() {
        if (!pqd) {
            KxY.t3p("base-platform");
            pqd = true;
        }
    }

    public static String t3p() {
        if (t3p == null) {
            t3p = Platform.PB();
        }
        assert (bgx.W1d(t3p != null));
        assert (bgx.W1d(!t3p.isEmpty()));
        return t3p;
    }

    private static String PB() {
        if (KxY.t3p()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            String string2 = Platform.getNativeComputerName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                bgx.WCG.pqd("Warning: determining macOS host name failed, using fallback instead.");
                string2 = InetAddress.getLocalHost().getHostName();
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                bgx.WCG.pqd("Error: unable to determine macOS host name.");
            }
        } else if (KxY.WCG()) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = System.getenv("COMPUTERNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
        } else if (KxY.pqd()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            try {
                String string3 = InetAddress.getLocalHost().getHostName();
                if (string3 != null && !string3.isEmpty()) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "localhost";
    }

    private static native String getNativeComputerName();

    public static UUID W1d() {
        if (W1d == null) {
            W1d = Platform.LZT();
        }
        assert (bgx.W1d(W1d != null));
        return W1d;
    }

    private static UUID LZT() {
        if (KxY.WCG()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483646, "SOFTWARE\\Microsoft\\Cryptography", "MachineGuid");
            return UUID.fromString(string);
        }
        if (KxY.t3p()) {
            String string = MacOsXIoKit.readRegistryStringValue("IOPlatformUUID");
            return UUID.fromString(string);
        }
        if (KxY.pqd()) {
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[]{57, 22, 57, 79, 57, 88, 57, 75, 57, 22, 57, 85, 57, 80, 57, 91, 57, 22, 57, 93, 57, 91, 57, 76, 57, 74, 57, 22, 57, 84, 57, 88, 57, 90, 57, 81, 57, 80, 57, 87, 57, 92, 57, 20, 57, 80, 57, 93};
                String string = xHm.WCG(byArray2);
                File file = null;
                File file2 = new File(string);
                if (file2.isFile()) {
                    file = file2;
                } else {
                    byArray = new byte[]{57, 22, 57, 92, 57, 77, 57, 90, 57, 22, 57, 84, 57, 88, 57, 90, 57, 81, 57, 80, 57, 87, 57, 92, 57, 20, 57, 80, 57, 93};
                    String string2 = xHm.WCG(byArray);
                    file = new File(string2);
                }
                byArray = luf.BiT(file);
                return UUID.nameUUIDFromBytes(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void pqd() {
        Thread.currentThread().setPriority(4);
        if (KxY.pqd()) {
            Platform.initThreadForBackgroundIONative();
        }
    }

    private static native void initThreadForBackgroundIONative();

    public static void WCG(File file) {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (KxY.pqd()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file.getAbsolutePath());
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (KxY.t3p()) {
            ProcessBuilder processBuilder = file.isDirectory() ? new ProcessBuilder("open", "-R", file.getAbsolutePath()) : new ProcessBuilder("open", file.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open " + file.getAbsolutePath() + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (KxY.WCG() && !WindowsPlatform.WCG(file.getAbsolutePath())) {
            throw new IOException("Couldn't open file: " + file.getAbsolutePath());
        }
    }

    public static void t3p(File file) {
        File file2;
        for (file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new FileNotFoundException();
        }
        if (KxY.pqd()) {
            File file3 = file2.isDirectory() ? file2 : file2.getParentFile();
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file3.getAbsolutePath());
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (KxY.t3p()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", "-R", file2.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open -R " + file2.getAbsolutePath() + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (KxY.WCG() && !WindowsPlatform.t3p(file2.getAbsolutePath())) {
            throw new IOException("Couldn't explore file: " + file2.getAbsolutePath());
        }
    }

    public static void WCG(String string) {
        assert (bgx.WCG(string != null && !string.isEmpty()));
        if (KxY.pqd()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", string);
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (KxY.t3p()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", string);
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open " + string + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (KxY.WCG() && !WindowsPlatform.WCG(string)) {
            throw new IOException("Couldn't open URL: " + string);
        }
    }

    public static String ocA() {
        try {
            if (KxY.pqd()) {
                return Platform.WGS();
            }
            if (KxY.WCG()) {
                return Platform.hFD();
            }
            if (KxY.t3p()) {
                return Platform.aaP();
            }
        }
        catch (Throwable throwable) {
            bgx.WCG.t3p(throwable);
        }
        return null;
    }

    private static String aaP() {
        try {
            noL noL2 = lgj.WCG(new String[]{"sw_vers"}, null);
            if (noL2.WCG() == 0) {
                String string = noL2.t3p();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            return null;
        }
    }

    private static String hFD() {
        try {
            noL noL2 = lgj.WCG(new String[]{"systeminfo"}, null);
            if (noL2.WCG() == 0) {
                String string = noL2.t3p();
                return string;
            }
            bgx.WCG.ocA("Error obtaining detailed OS info\nProcess returned exit code " + noL2.WCG() + "\nOutput:\n" + noL2.t3p() + "\n\nErrors:\n" + noL2.W1d());
            return null;
        }
        catch (ProcessException processException) {
            bgx.WCG.ocA("Error obtaining detailed OS info", processException);
            return null;
        }
    }

    private static String WGS() {
        String string = Platform.xzw();
        String string2 = Platform.DNK();
        return string + "\n" + string2;
    }

    private static String xzw() {
        try {
            noL noL2 = lgj.WCG(new String[]{"lsb_release", "-a"}, null);
            if (noL2.WCG() == 0) {
                String string = noL2.t3p();
                return string;
            }
            return "";
        }
        catch (ProcessException processException) {
            return "";
        }
    }

    private static String DNK() {
        try {
            return oie.WCG(new FileReader(new File("/proc/cpuinfo")));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static File LQe() {
        return ocA;
    }

    public static File BiT() {
        return LQe;
    }

    public static native void simulateCrashInNativeCode();

    public static File t3p(String string) {
        if (KxY.WCG()) {
            return Platform.LQe(string);
        }
        if (KxY.t3p()) {
            return Platform.ocA(string);
        }
        if (KxY.pqd()) {
            return Platform.pqd(string);
        }
        assert (bgx.W1d(false));
        return null;
    }

    private static File pqd(String string) {
        File file = new File("/media/" + string);
        if (!file.isDirectory()) {
            String string2 = System.getProperty("user.name");
            file = new File("/media/" + string2 + "/" + string);
            if (!(file.isDirectory() || (file = new File("/mnt/" + string)).isDirectory() || (file = new File("/mnt/" + string2 + "/" + string)).isDirectory())) {
                return null;
            }
        }
        return file;
    }

    private static File ocA(String string) {
        File file = new File("/Volumes/" + string);
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File LQe(String string) {
        File file;
        FileStore fileStore;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.type().equals("UDF") && !fileStore.type().equals("CDFS") || !fileStore.name().toLowerCase().startsWith(string.toLowerCase())) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.name().equalsIgnoreCase(string)) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static File W1d(String string) {
        if (KxY.WCG()) {
            return Platform.PB(string);
        }
        if (KxY.t3p()) {
            return Platform.BiT(string);
        }
        if (KxY.pqd()) {
            return Platform.LZT(string);
        }
        assert (bgx.W1d(false));
        return null;
    }

    private static File BiT(String string) {
        File file = new File("/Volumes");
        return Platform.WCG(file, string);
    }

    private static File WCG(File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File file3 = new File(file2, string);
                if (!file3.isDirectory()) continue;
                return file3;
            }
        }
        return null;
    }

    private static File PB(String string) {
        File file;
        Object object;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                File file2;
                object = Files.getFileStore(path);
                file = path.toFile();
                if (!((FileStore)object).type().equals("UDF") && !((FileStore)object).type().equals("CDFS") || !(file2 = new File(file, string)).isDirectory()) continue;
                return file2;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            object = path.toFile();
            file = new File((File)object, string);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private static File LZT(String string) {
        String string2 = System.getProperty("user.name");
        File file = Platform.WCG(new File("/media/" + string2), string);
        if (file == null && (file = Platform.WCG(new File("/media"), string)) == null && (file = Platform.WCG(new File("/mnt/" + string2), string)) == null) {
            file = Platform.WCG(new File("/mnt"), string);
        }
        return file;
    }

    public static native boolean supportsWindowsDpiAwareFunctionality();

    static {
        Platform.WCG();
        if (KxY.WCG()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "DESKTOP");
            ocA = string != null && !string.isEmpty() ? new File(string) : new File(luf.t3p(), "Desktop");
            String string2 = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
            if (string2 != null && !string2.isEmpty()) {
                LQe = new File(string2);
            } else {
                ocA = new File(luf.t3p(), "Documents");
            }
        } else {
            ocA = new File(luf.t3p(), "Desktop");
            LQe = luf.t3p();
        }
    }
}

