/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MidiOut;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;

public class cjL
extends ControllerExtension {
    private Transport WCG;
    private MasterTrack t3p;
    private TrackBank W1d;
    private MidiOut pqd;

    public cjL(Q3z q3z, ControllerHost controllerHost) {
        super(q3z, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        this.WCG = controllerHost.createTransport();
        this.WCG.crossfade().setIndication(true);
        this.W1d = controllerHost.createTrackBank(8, 0, 0);
        for (int i2 = 0; i2 < 8; ++i2) {
            Track track = (Track)this.W1d.getItemAt(i2);
            track.volume().setIndication(true);
            track.pan().setIndication(true);
        }
        this.t3p = controllerHost.createMasterTrack(0);
        this.t3p.volume().setIndication(true);
        this.t3p.pan().setIndication(true);
        MidiIn midiIn = controllerHost.getMidiInPort(0);
        midiIn.setMidiCallback(this::WCG);
        this.pqd = controllerHost.getMidiOutPort(0);
        this.pqd.sendSysex(TFs.WCG);
    }

    private void WCG(int n2, int n3, int n4) {
        int n5 = n2 & 0xF;
        int n6 = n2 >> 4 & 0xF;
        if (n2 == 176) {
            if (1 <= n3 && n3 <= 8) {
                ((Track)this.W1d.getItemAt(n3 - 1)).volume().set(n4, 128);
            } else if (n3 == 9) {
                this.t3p.volume().set(n4, 128);
            } else if (10 <= n3 && n3 < 18) {
                ((Track)this.W1d.getItemAt(n3 - 10)).pan().set(n4, 128);
            } else if (64 <= n3 && n3 <= 71 && n4 == 127) {
                ((Track)this.W1d.getItemAt(n3 - 64)).mute().toggle();
            } else if (n3 == 72 && n4 == 127) {
                this.t3p.mute().toggle();
            } else if (n3 == 18) {
                this.t3p.pan().set(n4, 128);
            } else if (n3 == 19) {
                this.WCG.crossfade().set(n4, 128);
            } else if (n3 == 32 && n4 == 127) {
                this.WCG.isArrangerRecordEnabled().toggle();
            } else if (n3 == 28 && n4 == 127) {
                this.WCG.togglePlay();
            } else if (n3 == 31 && n4 == 127) {
                this.WCG.stop();
            } else if (n3 == 30 && n4 == 127) {
                this.WCG.isArrangerLoopEnabled().toggle();
            } else if (n3 == 29 && n4 == 127) {
                this.WCG.fastForward();
            } else if (n3 == 27 && n4 == 127) {
                this.WCG.rewind();
            } else if (n3 == 81 && n4 == 127) {
                this.W1d.scrollPageBackwards();
            } else if (n3 == 82 && n4 == 127) {
                this.W1d.scrollPageForwards();
            } else if (n3 == 48) {
                this.WCG.tempo().incRaw(n4 < 64 ? (double)n4 : (double)(n4 - 128));
            }
        }
    }

    @Override
    public void exit() {
        this.pqd.sendSysex(TFs.t3p);
    }

    @Override
    public void flush() {
    }
}

