/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MidiOut;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RemoteControl;

public class ROE
extends ControllerExtension {
    private MidiIn WCG;
    private MidiOut t3p;
    private NoteInput W1d;
    private NoteInput pqd;
    private CursorTrack ocA;
    private PinnableCursorDevice LQe;
    private CursorRemoteControlsPage BiT;

    public ROE(xIR xIR2, ControllerHost controllerHost) {
        super(xIR2, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        this.WCG = controllerHost.getMidiInPort(0);
        this.WCG.setMidiCallback(this::WCG);
        this.WCG.setSysexCallback(this::WCG);
        this.W1d = this.WCG.createNoteInput("Keyboard", "80????", "90????");
        this.W1d.setShouldConsumeEvents(true);
        this.pqd = this.WCG.createNoteInput("Pads", "89????", "99????");
        this.pqd.setShouldConsumeEvents(true);
        this.t3p = controllerHost.getMidiOutPort(0);
        this.ocA = controllerHost.createCursorTrack("0", "Akai Advance", 0, 0, true);
        this.LQe = this.ocA.createCursorDevice();
        this.BiT = this.LQe.createCursorRemoteControlsPage(8);
        for (int i2 = 0; i2 < 8; ++i2) {
            RemoteControl remoteControl = this.BiT.getParameter(i2);
            remoteControl.setIndication(true);
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void WCG(int n2, int n3, int n4) {
        int n5 = n2 & 0xF;
        int n6 = n2 >> 4;
        switch (n6) {
            case 11: {
                if (50 > n3 || n3 >= 58) break;
                int n7 = n3 - 50;
                int n8 = n4 < 64 ? n4 : n4 - 128;
                double d2 = (float)n8 / 128.0f;
                this.BiT.getParameter(n7).inc(d2);
            }
        }
    }

    private void WCG(String string) {
        ((ControllerHost)this.getHost()).println("got sysex: " + string);
    }
}

