/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2015 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/*jslint node: true, vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, unparam: true */
/*global define, console*/

/**
    Wrapper for IMS errors as Javascript errors.
**/

'use strict';

/**
    IMS error codes
**/

var errorLookup = [];

function addError(code, index, description) {
    errorLookup[index] = {
        code: code,
        description: description
    };
}

function getError(index) {
    var error = errorLookup[index];
    if (!error) {
        error = {};
        if (index >= 401 && index < 600) {
            error.code = 'UNEXPECTED_RESPONSE';
            error.description = 'Got unexpected response from IMS server: ' + index + '.';
        } else {
            error.code = 'UNKNOWN_ERROR';
            error.description = 'Unknown error status: ' + index + '.';
        }
    }
    return error;
}

// Add all the IMS error codes (from IMSLib.h)
addError('FAILURE',                               1,   'General failure status.');
addError('INVALID_ARGUMENTS',                     2,   'Error returned if invalid arguments are passed to an API.');
addError('CANCEL',                                20,  'Error returned if the Http request is cancelled.');
addError('TIMEOUT',                               21,  'Error returned if the Http request is timed out.');
addError('HTTPFAILURE',                           22,  'Error returned if http request fails.');
addError('SSLFAILURE',                            23,  'Error returned if http request fails, due to SSL certifiaction error.');
addError('AUTH_PROXY_REQUIRED',                   24,  'Error returned if http request is being made behind proxy.');
addError('AUTH_PROXY_FAILED',                     25,  'Error returned if http request failed due to wrong proxy credentials.');
addError('IN_ACCESS_IDP',                         26,  'Error returned if IMSLib fails in accessing IDP server. Probably server is down.');
addError('ANOTHER_REQUEST_IN_PROCESS',            40,  'Error returned if async call to IMSLib is made when one async http request is already in progress.');
addError('IN_READ_USER_DATA',                     60,  'Error returned if IMSLib fails in reading user specific data from the user machine.');
addError('IN_SAVE_USER_DATA',                     61,  'Error returned if IMSLib fails in saving user specific data on the user machine.');
addError('IN_REMOVE_USER_DATA',                   62,  'Error returned if IMSLib fails in removing user specific data from the user machine.');
addError('USER_DATA_NOT_PRESENT',                 63,  'Error returned if IMSLib detects that user data is not present on the user machine.');
addError('IN_READ_DEVICE_TOKEN',                  64,  'Error returned if IMSLib fails in reading device token from the user machine.');
addError('IN_SAVE_DEVICE_TOKEN',                  65,  'Error returned if IMSLib fails in saving device token on the user machine.');
addError('IN_REMOVE_DEVICE_TOKEN',                66,  'Error returned if IMSLib fails in removing device token from the user machine.');
addError('DEVICE_TOKEN_NOT_PRESENT',              67,  'Error returned if device token is not present on the user machine.');
addError('INVALID_DEVICE_TOKEN',                  68,  'Error returned if invalid device token is present on the user machine.');
addError('CLIENTID_NOT_PRESENT',                  69,  'Error returned, if client id information is missing on the user machine.');
addError('IN_FETCH_USER_ACCOUNTS',                70,  'Error returned, if IMSLib fails in fetching user accounts details from the user machine.');
addError('IN_SAVE_USER_FOR_CLIENTID',             71,  'Error returned, if IMSLib fails in saving user id for a particular client id.');
addError('DEVICE_ID_NOT_PRESENT',                 72,  'Error returned if device id is not present on the user machine.');
addError('DEFAULT_USER_FOR_CLIENTID_NOT_PRESENT', 73,  'Error returned if there is no default user for client_id');
addError('NO_USER_RECORDS_PRESENT',               74,  'Error returned if there is no user records are present in opm.db');
addError('ACCESS_DENIED',                         80,  'Error returned if IMS server returns error code "access_denied" while generating token.');
addError('INVALID_REQUEST',                       81,  'Error returned if IMS server returns error code "invalid_request" while generating token.');
addError('INVALID_CLIENT',                        82,  'Error returned if IMS server returns error code "invalid_client" while generating token.');
addError('INVALID_GRANT',                         83,  'Error returned if IMS server returns error code "invalid_grant" while generating token.');
addError('UNAUTHORIZED_CLIENT',                   84,  'Error returned if IMS server returns error code "unauthorized_client" while generating token.');
addError('UNSUPPORTED_RESPONSE_TYPE',             85,  'Error returned if IMS server returns error code "unsupported_response_type" while generating token.');
addError('INVALID_SCOPE',                         86,  'Error returned if IMS server returns error code "invalid_scope" while generating token.');
addError('UNSUPPORTED_GRANT_TYPE',                87,  'Error returned if IMS server returns error code "unsupported_grant_type" while generating token.');
addError('BAD_REQUEST',                           88,  'Error returned if IMS server returns error code "bad_request" while generating token.');
addError('INVALID_CREDENTIALS',                   89,  'Error returned if IMS server returns error code "invalid_credentials" while generating token.');
addError('IN_GET_AUTH_DATA_FROM_IDP',             100, 'Error returned if IMSLib fails fetching authentication data from server.');
addError('IN_GET_DEVICE_TOKEN_FROM_IDP',          101, 'Error returned if IMSLib fails fetching device token from server.');
addError('IN_GET_REFRESH_TOKEN_FROM_IDP',         102, 'Error returned if IMSLib fails fetching device token from server.');
addError('IN_GET_ACCESS_TOKEN_FROM_IDP',          103, 'Error returned if IMSLib fails fetching device token from server.');
addError('IN_GET_PROFILE_DATA_FROM_IDP',          104, 'Error returned if IMSLib fails fetching device token from server.');
addError('TOU_CHANGED',                           120, 'Error returned if TOU has changed.');
addError('IN_REVOKE_DEVICE_TOKEN',                121, 'Error returned if IMSLib fails in revoking device token.');
addError('TOU_NOT_CURRENT',                       122, 'Terms of use acceptance is not current.');
addError('EVS_INVALID',                           123, 'Email Verification Status does not meet required policy.');
addError('ACCT_ACT_REQ',                          124, 'Some issue with the user account requires attention/action. i.e. COPPA or some other issue requiring user action, related to the user account rather than a subscription.');
addError('ACCT_DISABLED',                         125, 'Account is currently disabled.');
addError('SUBS_ACT_REQ',                          126, 'Some issue with the subscription requires attention/action. i.e. payment error etc.');
addError('SUBS_NO_SUB',                           127, 'No current subscription exists for the user. i.e. closed/removed.');
addError('NO_BUDDY_GROUP_FOR_CLIENT',             150, 'No buddy_group exists for the client queried.');
addError('CLIENT_REGISTERED_FOR_OTHER_GROUP',     151, 'Client is already registered for some group other than requested.');
addError('GROUP_ENTRY_NOT_PRESENT',               152, 'No entry exixts for the group queried.');
addError('IN_SAVE_GROUP_DATA',                    153, 'Error Occured while saving the buddy-group data.');
addError('CNAME_ENTRY_NOTPRESENT',                154, 'CNAME DNS entry is not present.');
addError('IN_SAVE_BACKOFF_DATA',                  155, 'Error saving backoff data.');


/**
    Javascript error object
**/

function IMSError(index) {
    Error.call(this);
    var data = getError(index);
    this.code = data.code;
    this.message = '[' + data.code + '] ' + data.description;
}

IMSError.prototype = new Error();
IMSError.prototype.name = 'IMSError';
delete IMSError.prototype.stack;

// Constant s
IMSError.SUCCESS = 0;

// Export
module.exports = IMSError;
