/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2016 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/*jslint node: true, vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, unparam: true, stupid: true */
/*global define, console*/

/**
    This file can be to obtain a descriptor listing the native libraries
    this module exports and depends on.
**/

'use strict';

var path = require('path');
var fs = require('fs');
var getIMSLibPath = require('./src/IMSLibPath');

function getRootPathForModule(main) {
    var moduleRoot = path.dirname(main);

    while (moduleRoot && !fs.existsSync(path.join(moduleRoot, 'package.json'))) {
        moduleRoot = path.dirname(moduleRoot);
    }

    return moduleRoot;
}

function getConfig(debug) {
    var ffiRootDir = getRootPathForModule(require.resolve('ffi'));
    var refRootDir = getRootPathForModule(require.resolve('ref'));
    var configDir = debug ? 'Debug' : 'Release';

    return {
        rootDir: __dirname,
        nodeGypModules: [ ffiRootDir, refRootDir ],
        binaries: [ getIMSLibPath(debug),
            path.join(ffiRootDir, 'build', configDir, 'ffi_bindings.node'),
            path.join(refRootDir, 'build', configDir, 'binding.node') ]
    };
}

module.exports = {
    config: getConfig
};
