node-imslib
===========

NPM module for IMSLib.

This provides a simple wrapper over the C++ [IMSLib API](https://wiki.corp.adobe.com/display/Suites/IMSLib+API).

Builds of IMSLib are available from [codex](https://codex.corp.adobe.com) under OOBEShared/IMSLib.

To use this package, simply add the following line to your package.json dependencies (referencing the appropriate version):

    "node-imslib": "git+ssh://git@git.corp.adobe.com:ProjectCentral/node-imslib.git#v1.0.8",

After running `npm install`, you can then access the API by:

    var IMSLib = require('node-imslib');

We expose the following APIs (see the [IMSLib API Reference](https://wiki.corp.adobe.com/display/Suites/IMSLib+API) for more detail). There are a few small differences between these and the native C++ libraries: IMSStatus error codes are wrapped in a more informative IMSError object, which is passed as the first parameter in any callback for asynchronous APIs, or thrown as an exception for synchronous APIs. XML data is parsed into Javascript objects (as is JSON data obtained from the IMS server).

* `createRef(isGM)`: returns an imsRef
* `createRefEx(imsEndpoint)`: returns an imsRef
* `createRefForProductVersion(LEID)`: returns an imsRef
* `releaseRef(imsRef)`
* `fetchAccessToken(imsRef, clientId, clientSecret, userAccountGuid, serviceAccountGuid, scope, callback)`
* `fetchAccessToken2(imsRef, xmlData, callback)`
* `fetchIDPResponseForKey(imsRef, data, callback)`
* `revokeDeviceToken(imsRef, userAccountGuid, clientId, clientSecret, callback)`
* `fetchAccounts(imsRef, clientId)`: returns an array of user account information objects
* `fetchDefaultUserInfoForClientId(imsRef, clientId)`: returns an object with the data for the last logged-in user
* `fetchUserProfileData(imsRef, userAccountGuid)`: returns an object the data for the user specified by userAccountGuid
* `setProxyCredentials(proxyUsername, proxyPassword)`
* `setProxyCredentialsInIMSLibSession(imsRef, proxyUsername, proxyPassword, saveOnDisk)`
* `getProxyCredentialsFromIMSLibSession(imsRef)`: returns an object with the proxy credentials
* `fetchContinueToken(imsRef, bearerToken, targetClientId, redirectUri, scope, responseType, locale, callback)`
* `EEPLogin(imsRef, data, callback)`
* `setUserAsDefaultForClientId(imsRef, userAccountGuid, clientId)`
* `getDeviceID(imsRef)`: returns a string which is the device ID
* `logOutUserForClient(imsRef, userAccountGuid, clientId, callback)`
* `registerClientToGroup(imsRef, clientId, groupId)`
* `deregisterClientFromGroup(imsRef, clientId, groupId)`
* `fetchFeatureFlags(imsRef, clientId, accessToken, releaseFlag, callback)`
* `fetchReleaseFlag(imsRef, clientId, accessToken, callback)`
* `setRetryAfterResponseHandlingData(imsRef, maxRetryDurationInMillisecs, maxRetryCount)`

