//agf_include "math/cubic.inc"

uniform sampler2D texture_param;
uniform vec2 texture_normalizer;

in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  vec4 premult_color = cubic_filter(texture_param, v_uv / texture_normalizer.xy, texture_normalizer.xy);

  fragColor = (premult_color.a > 0.0)
    ? vec4(premult_color.rgb / premult_color.a, premult_color.a)
    : vec4(0.0, 0.0, 0.0, 0.0);
}
