//agf_include "math/safe_dot.inc"

uniform vec4 color;
uniform bool should_shade;
out vec4 fragColor;

in vec3 v_N;
in vec3 v_P_camera;
in vec3 v_P_clip;
in vec3 v_U;

void main() {
  vec3 N = normalize(v_N);
  vec3 U = normalize(v_U);

  float dim = safe_dot(N, U);
  vec3 final_color = should_shade ? color.rgb * dim : color.rgb;
  fragColor = vec4(final_color.r, final_color.g, final_color.b, color.a);
}
