//agf_include "logarithmic_z.inc"

uniform vec4 color;
uniform vec4 occluded_color;
uniform sampler2D depth_texture;
uniform mat4 viewport_matrix;

in float v_depth; // depth in log z of line
in vec3 v_P_clip;

out vec4 fragColor;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

float map_range(float value, float src_low, float src_high, float dest_low, float dest_high) {
  return dest_low + (dest_high - dest_low) * (value - src_low) / (src_high - src_low);
}

void main() {
  // get position in texture's range from clip coordinate, to compare to sample from texture
  float normalized_x = map_range(v_P_clip.x, -1, 1, 0, 1);
  float normalized_y = map_range(v_P_clip.y, -1, 1, 0, 1);
  float normalized_z = map_range(v_P_clip.z, -1, 1, 1, 0);

  // the depth of the current pixel in log space
  float log_depth = map_range(v_depth, -1, 1, 0, 1);

  vec4 tiled_uv = vec4(normalized_x, normalized_y, normalized_z, 1.0);
  tiled_uv = viewport_matrix * tiled_uv;

  // check for occlusion
  float scene_log_depth = texture(depth_texture, tiled_uv.xy).r;

  //LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF

  vec4 final_color = scene_log_depth < log_depth ? occluded_color : color;

  fragColor = final_color;
}
