//agf_include "logarithmic_z.inc"

uniform vec4 color;
out vec4 fragColor;

uniform float width; // line width
uniform float dash_length; // TODO: use this
uniform sampler2D depth_texture;
uniform mat4 viewport_matrix;

in float v_line_distance_from_center; // line distance is signed, varying between -1, and 1 across the triangle
in float v_line_distance; // distance from beginning of path, in untransformed path units.
in float v_depth;
in vec3 v_P_clip;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

float map_range(float value, float src_low, float src_high, float dest_low, float dest_high) {
  return dest_low + (dest_high - dest_low) * (value - src_low) / (src_high - src_low);
}

void main() {
  // line distance is "across" the line, rather than down the path of the line
  // when we are close to 1, we are far from the center of the line.
  // close to 0, we are in the center of the line

  float start_fading = max(width - 1.5, 0.0);
  float alpha = 1.0 - smoothstep((start_fading / width), 1.0, abs(v_line_distance_from_center));

  float normalized_x = map_range(v_P_clip.x, -1, 1, 0, 1);
  float normalized_y = map_range(v_P_clip.y, -1, 1, 0, 1);
  float normalized_z = map_range(v_P_clip.z, -1, 1, 1, 0);

  float v_log_depth = map_range(v_depth, -1, 1, 0, 1);

  vec4 tiled_uv = vec4(normalized_x, normalized_y, normalized_z, 1.0);
  tiled_uv = viewport_matrix * tiled_uv;

  vec2 depth_uv = vec2(tiled_uv.x, tiled_uv.y);
  float scene_log_depth = texture(depth_texture, depth_uv).r;

  if (scene_log_depth < v_log_depth) {
    if (mod(v_line_distance, 0.1) < 0.05) {
      alpha = 0.0;
    }
  }

  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF

  fragColor = vec4(color.r, color.g, color.b, alpha * color.a);

    // Debug
    // // fragColor = vec4(scene_log_depth, v_log_depth, 0.0, 1.0);
}
