//agf_include "logarithmic_z.inc"

layout(location=0) in vec3 agf_position;
layout(location=1) in vec4 agf_color; // contains next pt and direction
layout(location=2) in vec3 agf_normal; // contains prev point
layout(location=3) in vec2 agf_uv; // contains distance along line (float, 0)

// view parameters
uniform mat4 model_view_proj_matrix;
uniform vec2 screen_size;
// uniform float dash_length;

// line parameters
uniform float width; // line width
// uniform int miter;

out float v_depth;
out vec3 v_P_clip;
out float v_line_distance_from_center;
out float v_line_distance;

LOGZ_VERTEX_DECLARE_FLOGZ
LOGZ_VERTEX_DECLARE_FCOEF

void main() {
  // unpack data from layout. I know, I know.
  vec4 position = vec4(agf_position, 1.0);
  vec4 previous = vec4(agf_normal, 1.0);
  vec4 next = vec4(agf_color.xyz, 1.0);

  vec4 position_clip = model_view_proj_matrix * position;
  vec4 previous_clip = model_view_proj_matrix * previous;
  vec4 next_clip = model_view_proj_matrix * next;

  float aspect = screen_size.x/screen_size.y;
  vec2 aspect_vec = vec2(aspect, 1.0f);
  vec2 position_screen = position_clip.xy / position_clip.w * aspect_vec;
  vec2 previous_screen = previous_clip.xy / previous_clip.w * aspect_vec;
  vec2 next_screen = next_clip.xy / next_clip.w * aspect_vec;

  vec2 dir;
  if (position_screen == previous_screen) {
    dir = normalize(next_screen - position_screen);
  } else if (position_screen == next_screen) {
    dir = normalize(position_screen - previous_screen);
  } else {
    dir = normalize(position_screen - previous_screen);
    // TODO mitering
    // vec2 dirA = dir;
    // if (miter == 1) {
    //   vec2 dirB = normalize((nextScreen - currentScreen));
    //   //now compute the miter join normal and length
    //   vec2 tangent = normalize(dirA + dirB);
    //   vec2 perp = vec2(-dirA.y, dirA.x);
    //   vec2 miter = vec2(-tangent.y, tangent.x);
    //   dir = tangent;
    //   len = thickness / dot(miter, perp);
    // }
  }

  float orientation = agf_color.a;
  vec2 normal = vec2(-dir.y, dir.x) * orientation;
  normal *= width / screen_size.y;
  normal.x /= aspect;

  vec4 offset = vec4(normal, 0.0, 0.0);

  // vec4 dis = model_view_proj_matrix * vec4(agf_uv.x, 0.0, 0.0, 1.0);
  v_line_distance = agf_uv.x;

  // send point orientation to fragment shader
  v_line_distance_from_center = orientation;
  // TODO: we could make the distance be in world space, so that it has perspective, and dashes don't get larger when scaling

  float position_clip_w = position_clip.w;
  position_clip /= position_clip.w;

  v_P_clip = position_clip.xyz;

  // the position of this vertex is offset to the left or right depending on whether it is on left or right side of line
  // L ._. R
  //   |/|
  // L ._. R
  gl_Position = position_clip + offset;

  // convert the depth of the vertex into log space and store in glPosition.z
  v_depth = gl_Position.z;
  //gl_Position.z = gl_Position.z + v_depth*1.175494351e-38;
  //flogz = 1.0 + position_clip_w;
}
