//agf_include "logarithmic_z.inc"
//agf_include "materials/shadow_support.inc"
//agf_include "math/safe_dot.inc"
//agf_include "color/hsv.inc"
//agf_include "color/srgb.inc"

uniform vec3 light_direction;
uniform float daylight_cloudiness;
uniform bool daylight_sun_enabled;
uniform float daylight_intensity;
uniform float ambient_light_intensity;
uniform vec3 ambient_light_color;
uniform vec3 daylight_color;
uniform bool is_camera_below_ground;

in vec2 v_uv;
in vec3 v_P_shadow;
in vec3 v_N;

LOGZ_FRAGMENT_DECLARE_FLOGZ
LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

out vec4 fragColor;

void main() {
  float NdL = safe_dot(normalize(v_N), light_direction);
  float shadowMask = get_shadow(NdL, v_P_shadow);

  vec3 ambientColorHSV = rgb_to_hsv(ambient_light_color);
  float adjustedAmbientIntensity = ambient_light_intensity * ambientColorHSV.b;
  float intensityMult = adjustedAmbientIntensity * 0.25;
  if (daylight_sun_enabled) {
    vec3 daylightColorHSV = rgb_to_hsv(daylight_color);
    float adjustedDaylightIntensity = daylight_intensity * daylightColorHSV.b;
    intensityMult = (adjustedDaylightIntensity) / (adjustedDaylightIntensity + (intensityMult * 0.33));
    intensityMult *= (1.0 - (daylight_cloudiness * 0.5)) * 0.5;
  }
  else {
    intensityMult *= 0.5; //(match object to object shadows which need to multiply by normals to prevent shadow acne)
  }
  float alphamix = shadow_opacity * ground_shadow_opacity * clamp(intensityMult, 0.0, 1.0);
  vec4 shadowColor = vec4(0.0, 0.0, 0.0, alphamix);

  // no shadows when we're beneath the ground plane
  shadowMask *= 1.0 - float(is_camera_below_ground);
  shadowColor.a = shadowColor.a * shadowMask;

  fragColor = shadowColor;

  LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF
}
