// #extension GL_ARB_shader_texture_lod: require

uniform sampler2D texture_param;
uniform sampler2D depth_texture_param;
uniform float aperture;
uniform float focal_distance;
uniform float focal_length;
uniform float far_clip;
uniform float rcp_frame_height;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  float log_depth = texture(depth_texture_param, v_uv).r;
  float linear_depth = pow(far_clip + 1.0, log_depth) - 1.0;
  float circle_of_confusion_radius = abs( aperture * (focal_length * (focal_distance - linear_depth)) /
            (linear_depth * (focal_distance - focal_length)) );
  float lod = min(circle_of_confusion_radius*2.0, 20.0); // clamp lod to something not too ridiculus
  //close objects aren't getting blurred enough......
  if (linear_depth < focal_distance) {
    lod *= 3;
  }
  //infinity in focus
  if (linear_depth > far_clip - 1.0) {
    lod = 0.25; //keeps the grid from aliasing
  }
  fragColor = vec4(textureLod(texture_param, v_uv, lod).rgba);
}
