//agf_include "math/inside_box.inc"

in vec4 v_color;
in vec3 v_P_clip;
in vec2 v_uv;

out vec4 fragColor;
uniform vec4 decal_color;
uniform float address_mode;
uniform bool decal_texture_enabled;
uniform bool invert_output_color;
uniform sampler2D decal_texture;
uniform sampler2D decal_alpha_texture;
//Aspect-ratio-maintaing scales passed here: .xy for decal_texture, .zw for decal_alpha_texture
uniform mat4 decal_affine;
uniform mat4 mask_affine;


#define DEBUG_OUT_OF_RANGE_UVS 0
vec2 WrapUV(vec2 old, float mode ){
  vec2 wrapped = old;
  if(mode <= 0.0){
    wrapped = fract(wrapped);
    if( mode < 0.0){
      if (mod(old.x, 2) < 1)
      {
        // even
      }
      else
      {
        wrapped.x = 1.0-wrapped.x;
      }

      if (mod(old.y, 2) < 1)
      {
        // even
      }
      else
      {
        wrapped.y = 1.0-wrapped.y;
      }
    }
  }else{

  }
  return wrapped;
}

void main() {

  //Scaling RGB and alpha UVs, to maintain the aspect ratios.
  vec2 decal_uv = (decal_affine * vec4(v_uv.x, v_uv.y, 0.0, 1.0)).xy;

  vec2 decal_alpha_uv = (mask_affine * vec4(v_uv.x, v_uv.y, 0.0, 1.0)).xy;

  {
    decal_uv = WrapUV(decal_uv, address_mode);
    decal_alpha_uv = WrapUV(decal_alpha_uv, address_mode);
  }

  //Standard lookup: if a RGB texture is not enabled, use the base color.
  vec3 decal_sample = decal_color.rgb; // Note that decal_color.a alpha is completely ignored right now,
                                       // (alpha controlled by decal_alpha_texture)
  if (decal_texture_enabled) {
    decal_sample = texture(decal_texture, decal_uv).rgb;
  }

  //Alpha is controlled exclusively by decal_alpha_texture right now.
  float decal_alpha = texture(decal_alpha_texture, decal_alpha_uv).r;
  vec4 final_color = vec4(decal_sample, decal_alpha);

  if (invert_output_color) {
    //Translucency blending, translucency value is just 1-decal_alpha  for now -@nikolai3d
    final_color = vec4(1.0 - decal_alpha, 1.0 - decal_alpha, 1.0 - decal_alpha, 1.0); //vec3(1.0, 1.0, 1.0)-decal_sample
  }
  
  if( clamp(decal_uv, 0.0, 1.0) != decal_uv){
    discard;
  }
  
  if( clamp(decal_alpha_uv, 0.0, 1.0) != decal_alpha_uv){
    discard;
  }

  fragColor = final_color;
#if DEBUG_OUT_OF_RANGE_UVS
//  For debugging only - switch off early discards and mark pixels if the UVs are out of range.
  if (decal_uv.x < 0.0 && decal_uv.y < 0.0) {
    fragColor = vec4(0.0, 1.0, 0.0, 1.0);
  }
  
  if (decal_uv.x > 1.0 && decal_uv.y > 1.0) {
    fragColor = vec4(1.0, 0.0, 0.0, 1.0);
  }
  
  if (decal_uv.x < 0.0 && decal_uv.y > 1.0) {
    fragColor = vec4(1.0, 1.0, 0.0, 1.0);
  }
  
  if (decal_uv.x > 1.0 && decal_uv.y < 0.0) {
    fragColor = vec4(0.0, 1.0, 1.0, 1.0);
  }
  
  if (decal_uv.x > 0.0 && decal_uv.x < 1.0 && decal_uv.y < 0.0) {
    fragColor = vec4(0.0, 0.0, 0.5, 1.0);
  }
  
  if (decal_uv.x > 0.0 && decal_uv.x < 1.0 && decal_uv.y > 1.0) {
    fragColor = vec4(0.0, 0.0, 1.0, 1.0);
  }
  
  if (decal_uv.y > 0.0 && decal_uv.y < 1.0 && decal_uv.x < 0.0) {
    fragColor = vec4(0.5, 0.0, 0.5, 1.0);
  }
  
  if (decal_uv.y > 0.0 && decal_uv.y < 1.0 && decal_uv.x > 1.0) {
    fragColor = vec4(1.0, 0.0, 1.0, 1.0);
  }
  
#endif
  
}
