
#ifndef PI
#define PI 3.14159265359
#endif

#ifndef RADIAL_SAMPLES
#define RADIAL_SAMPLES 10
#endif

float inside_uv(in sampler2D i_mask_texture,vec2 i_uv) {
  vec4 texture_sample = texture(i_mask_texture, i_uv);
  if (texture_sample.r < 0.5) { //We are outside the mapped UV space
    return 0.0;
  }
  
  return 1.0;
}

vec4 fix_artifacts(in sampler2D i_source_texture,
                   in sampler2D i_mask_texture,
                   in vec2 i_uv,
                   in vec2 i_source_texture_normalizer,
                   in bool i_invert_input_color){
  
  vec4 texture_sample = texture(i_source_texture, i_uv);
  float inside = inside_uv(i_mask_texture,i_uv);
  
  vec4 base_color = texture_sample.rgba;
  vec4 filled_color = base_color;

  if (inside < 0.5) { //we are outside the mapped UV space
    //Look around, version 1
    vec2 tn = i_source_texture_normalizer*1.0;
    //    float neigbor_weight = 0.123317;
    //    float diagonal_weight = 0.077847;
    //    vec2 uv0 = v_uv+vec2(tn.x, 0.0);
    //    vec4 p0 = texture(source_texture, uv0);
    //    float w0 = neigbor_weight*inside_uv(uv_mask_texture, uv0);
    //
    //    vec2 uv1 = v_uv+vec2(tn.x, tn.y);
    //    vec4 p1 = texture(source_texture, uv1);
    //    float w1 = diagonal_weight*inside_uv(uv_mask_texture, uv1);
    //
    //    vec2 uv2 = v_uv+vec2(0, tn.y);
    //    vec4 p2 = texture(source_texture, uv2);
    //    float w2 = neigbor_weight*inside_uv(uv_mask_texture, uv2);
    //
    //    vec2 uv3 = v_uv+vec2(-tn.x, tn.y);
    //    vec4 p3 = texture(source_texture, uv3);
    //    float w3 = diagonal_weight*inside_uv(uv_mask_texture, uv3);
    //
    //    vec2 uv4 = v_uv+vec2(-tn.x, 0);
    //    vec4 p4 = texture(source_texture, uv4);
    //    float w4 = neigbor_weight*inside_uv(uv_mask_texture, uv4);
    //
    //    vec2 uv5 = v_uv+vec2(-tn.x, -tn.y);
    //    vec4 p5 = texture(source_texture, uv5);
    //    float w5 = diagonal_weight*inside_uv(uv_mask_texture, uv5);
    //
    //    vec2 uv6 = v_uv+vec2(0, -tn.y);
    //    vec4 p6 = texture(source_texture, uv6);
    //    float w6 = neigbor_weight*inside_uv(uv_mask_texture, uv6);
    //
    //    vec2 uv7 = v_uv+vec2(tn.x, -tn.y);
    //    vec4 p7 = texture(source_texture, uv7);
    //    float w7 = diagonal_weight*inside_uv(uv_mask_texture, uv7);
    //
    //    float weightsum = w0+w1+w2+w3+w4+w5+w6+w7;
    //    if (weightsum > 0.0) {
    //      vec4 additional_color = (p0*w0+p1*w1+p2*w2+p3*w3+p4*w4+p5*w5+p6*w6+p7*w7)/(weightsum);
    //      final_color = additional_color;
    //    } else {
    //      //We're way outside;
    //      final_color = base_color;
    //    }
    
    //Look around, version 2
    //    vec4 sampleBounds = vec4(0.0, 0.0, 1.0, 1.0);
    //    float weightsum = 0.0;
    //    float angle = 0.0;
    //    vec4 averageColor = vec4(0.0, 0.0, 0.0, 0.0);
    //    float radius = 1.2;
    //    for( int i=0; i<SAMPLES; i++ ){
    //      angle += 1.0/(float(SAMPLES)/2.0) * PI;
    //      vec2 testPointOffset = vec2( (radius*tn.x)*cos(angle), (radius*tn.y)*sin(angle) );
    //      vec2 testPoint = clamp( v_uv + testPointOffset, sampleBounds.xy, sampleBounds.zw );
    //      float weight = inside_uv(uv_mask_texture, testPoint);
    //      weightsum += weight;
    //      if (weight > 0) {
    //        averageColor += weight*texture(source_texture, testPoint);
    //      }
    //    }
    //
    //    if (weightsum > 0.0) {
    //      vec4 additional_color = averageColor/weightsum;
    //      final_color = additional_color;
    //    } else {
    //      //We're way outside;
    //      final_color = base_color;
    //    }
    
    //Look around (5x5 Gaussian Kernel), version 3
    vec4 sampleBounds = vec4(0.0, 0.0, 1.0, 1.0);
    float weightsum = 0.0;
    vec4 averageColor = vec4(0.0, 0.0, 0.0, 0.0);
    float scale = 1.0;
    float sigma = 1.0;
    float sigma2squared = 2.0*sigma*sigma;
    for (int i = -2; i<=2; i++) {
      for (int j = -2; j<=2; j++) {
        float x = scale*float(i);
        float y = scale*float(j);
        vec2 testPointOffset = vec2( x*tn.x, y*tn.y);
        float gaussWeight = exp(-(x*x+y*y)/sigma2squared);
        vec2 testPoint = clamp( i_uv + testPointOffset, sampleBounds.xy, sampleBounds.zw );
        float weight = inside_uv(i_mask_texture, testPoint)*gaussWeight;
        weightsum += weight;
        if (weight > 0) {
          averageColor += weight*texture(i_source_texture, testPoint);
        }
      }
    }
    
    if (weightsum > 0.0) {
      vec4 additional_color = averageColor/weightsum;
      filled_color = additional_color;
    }
  }

// No longer needed - was used only for translucency - @nikolai3d
//  if (i_invert_input_color) {
//    filled_color.rgb = vec3(1.0, 1.0, 1.0)-filled_color.rgb;
//  }

  return filled_color;
}

