layout(location=0) in vec3 agf_position;
layout(location=1) in vec4 agf_color;
layout(location=2) in vec3 agf_normal;

uniform mat4 model_view_proj_matrix;
uniform mat4 model_view_it_matrix;

out vec3 v_N;
out vec3 v_color;

void main() {
  vec4 P;

  P.xyz = agf_position;
  P.w = 1.0;

  vec4 P_clip = model_view_proj_matrix * P;

  vec4 mesh_normal;
  mesh_normal.xyz = agf_normal;
  mesh_normal.w = 0.0;

  vec4 normal_camera = model_view_it_matrix * mesh_normal;
  vec3 normal_camera3 = vec3(normal_camera.x, normal_camera.y, normal_camera.z);
  normal_camera3 = normalize(normal_camera3);

  v_N = normal_camera3;
  v_color = agf_color;
  gl_Position = P_clip;
}
