layout(location=0) in vec3 agf_position;
layout(location=1) in vec4 agf_color;
layout(location=3) in vec2 agf_uv;

uniform mat4 model_view_proj_matrix;
uniform mat4 tile_matrix;

out vec4 v_color;
out vec3 v_P_clip;
out vec2 v_uv;

void main() {
  vec4 position = vec4(agf_position, 1.0);
  vec4 position_clip = model_view_proj_matrix * position;


  vec4 uv = vec4(agf_uv, 0.0, 1.0);
  vec4 uv_tile = tile_matrix * uv;

  v_P_clip = position_clip.xyz;
  v_uv = uv_tile.xy;
  v_color = agf_color;

  gl_Position = position_clip;
}
