#define MAX_POISSON_SAMPLES 16

const vec2 poisson_disk[MAX_POISSON_SAMPLES] = vec2[MAX_POISSON_SAMPLES](
  vec2(-0.613392, 0.617481),
  vec2(0.170019, -0.040254),
  vec2(-0.299417, 0.791925),
  vec2(0.645680, 0.493210),
  vec2(-0.651784, 0.717887),
  vec2(0.421003, 0.027070),
  vec2(-0.817194, -0.271096),
  vec2(-0.705374, -0.668203),
  vec2(0.977050, -0.108615),
  vec2(0.063326, 0.142369),
  vec2(0.203528, 0.214331),
  vec2(-0.667531, 0.326090),
  vec2(-0.098422, -0.295755),
  vec2(-0.885922, 0.215369),
  vec2(0.566637, 0.605213),
  vec2(0.039766, -0.396100));

float random(vec4 seed4) {
  float dot_product = dot(seed4, vec4(12.9898,78.233,45.164,94.673));
  return fract(sin(dot_product) * 43758.5453);
}

int random_poisson_index(int num_samples, int index) {
  float f_num_samples = float(num_samples);
  return int(mod(f_num_samples*random(vec4(gl_FragCoord.xyy, index)), f_num_samples));
}

// map: the sampler to sample from
// uv_center: the uv to sample around
// sample distance: in UV space - 0 is all samples that at the uv_center, 1.0 is the entire uv range.
// poisson_index: must be in the range [0, NUM_POISSON_SAMPLES)
vec4 get_sample_poisson(sampler2D map, vec2 uv_center, float sample_distance, int poisson_index) {
  return texture(map, uv_center + poisson_disk[poisson_index] * sample_distance);
}
