#define DECLARE_TEXTURE_SCALAR_SAMPLER(name) \
uniform float name##_strength; \
uniform sampler2D name##_texture; \
uniform bool name##_enabled;

#define DECLARE_TEXTURE_NORMAL_SAMPLER(name) \
uniform sampler2D name##_texture; \
uniform bool name##_enabled;

#define DECLARE_TEXTURE_COLOR_SAMPLER(name) \
uniform float name##_strength; \
uniform vec4 name##_color; \
uniform sampler2D name##_texture; \
uniform bool name##_enabled;

#define SAMPLE_SCALAR(name, uv) \
( name##_enabled ? texture(name##_texture, uv).r : name##_strength )

#define SAMPLE_NORMAL(name, uv) \
( name##_enabled ? 2.0 * texture(name##_texture, uv).rgb - vec3(1.0) : vec3(0.0, 0.0, 1.0) )

#define SAMPLE_COLOR(name, uv) \
( name##_enabled ? texture(name##_texture, uv) : name##_color )
