//agf_include "color/srgb.inc"
//agf_include "color/tonemap_identity.inc"

uniform sampler2D texture_param;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  // Sample color from texture.
  vec4 color = texture(texture_param, v_uv);

  // Tonemap and gamma encode the color components then clamp both color and alpha.
  vec3 color_unpremult = (color.a == 0.0) ? vec3(0.0) : vec3(color.rgb / color.a);
  fragColor = clamp(vec4(color.a * linear_to_srgb(tonemap(color_unpremult.rgb)), color.a), 0.0, 1.0);
}
