//agf_include "color/srgb.inc"

uniform sampler2D texture_param;
uniform float opacity;
in vec2 v_uv;
layout(location = 0) out vec4 fragColor;

void main() {
  // Sample color from texture.
  vec4 color = vec4(texture(texture_param, v_uv));

  // Remove sRGB gamma encoding then clamp both color and alpha.
  fragColor = clamp(vec4(srgb_to_linear(color.rgb), color.a), 0.0, 1.0);
}
