#ifndef MAX_RGBD_RANGE
#define MAX_RGBD_RANGE 255.0
#endif

vec3 rgbd_to_rgb(vec4 rgbd)
{
  return rgbd.rgb * ((MAX_RGBD_RANGE / 255.0) / rgbd.a);
}

vec4 rgb_to_rgbd(vec3 rgb)
{
    float maxRGB = max(rgb.r,max(rgb.g,rgb.b));
    float D      = max(MAX_RGBD_RANGE / maxRGB, 1.0);
    D            = clamp(floor(D) / 255.0, 0.0, 1.0);
    return vec4(rgb.rgb * (D * (255.0 / MAX_RGBD_RANGE)), D);
}
