$input v_texcoord0

SAMPLER2D(InputTexture0, 0); // front Blend
SAMPLER2D(InputTexture1, 1); // back blend
SAMPLER2D(InputTexture2, 2); // final alpha
SAMPLER2D(InputTexture3, 3); // background src color

void main() 
{ 
    vec4 frontColor = texture2D(InputTexture0,  v_texcoord0);
    vec4 backColor = texture2D(InputTexture1,  v_texcoord0);
    vec4 finalAlpha = texture2D(InputTexture2,  v_texcoord0);
    vec4 srcColor = texture2D(InputTexture3,  v_texcoord0);
	//float transparencyMask = texture2D(InputTexture2, v_texcoord0).r;

    float alphaMultiplier = (1.0 - frontColor.a);
    gl_FragColor.rgb = (frontColor.rgb) + (backColor.rgb * vec3(alphaMultiplier,alphaMultiplier,alphaMultiplier));
    gl_FragColor.a = max(backColor.a, frontColor.a);

    float has_color = dot(backColor, vec4(1));

    if(has_color > 0.0f){
        backColor.rgb =  mix( srcColor.rgb, backColor.rgb * srcColor.rgb, 1.0 - backColor.a );
    }else{
        backColor.rgb = srcColor.rgb;
    }
    
    frontColor.rgb = mix( frontColor.rgb, frontColor.rgb * backColor.rgb, 1.0 - frontColor.a );
    gl_FragColor.rgb = (1.0 - finalAlpha.a)*srcColor.rgb + finalAlpha.a * frontColor.rgb;
    
    gl_FragColor.a = 1.0f ;
}
