$input v_texcoord0

SAMPLER2D(InputTexture0, 0); // front Blend
SAMPLER2D(InputTexture1, 1); // back blend
SAMPLER2D(InputTexture2, 2); // final alpha
SAMPLER2D(InputTexture3, 3); // dest color

SAMPLER2D(InputTexture4, 4); // front Blend
SAMPLER2D(InputTexture5, 5); // back blend
SAMPLER2D(InputTexture6, 6); // final alpha
SAMPLER2D(InputTexture7, 7); // dest color

SAMPLER2D(InputTexture8, 8); // final alpha

// note, we don't need to know the alpha for back
vec4 combine_layer( vec4 front, vec4 back){
    vec2 trans_alpha = unpack_16(front.a);

    //back.rgb*front.rgb is wrong as it is bC * (sC + Spec) => bC*sC + Spec*bC
    // to correct it should be (bC*sC)+Spec => bC*sC + Spec  
    vec3 mixed_front_color = mix( front.rgb, back.rgb*front.rgb, trans_alpha.x)*trans_alpha.y;
    //mixed_front_color = mixed_front_color*0.00001 + vec3( trans_alpha.x ); 
    mixed_front_color += (1.0 - trans_alpha.y)*back.rgb;
    vec4 final = vec4(mixed_front_color, max(back.a, trans_alpha.y) );
    return final;
}

void main() 
{ 
    vec4 frontColor = texture2D(InputTexture0,  v_texcoord0);
    
    vec4 frontColor2 = texture2D(InputTexture1,  v_texcoord0);
    vec4 frontColor3 = texture2D(InputTexture2,  v_texcoord0);
    vec4 frontColor4 = texture2D(InputTexture3,  v_texcoord0);

    vec4 backColor = texture2D(InputTexture4,  v_texcoord0);
    vec4 backColor2 = texture2D(InputTexture5,  v_texcoord0);
    vec4 backColor3 = texture2D(InputTexture6,  v_texcoord0);
    
    vec4 backColor4 = texture2D(InputTexture7,  v_texcoord0);

    vec2 uv = v_texcoord0.xy + vec2(0.5);
    vec4 srcColor = texture2D(InputTexture8,  uv*0.5 + vec2(0.75, 0.25));
    // means if all front layer has 0 alpha, it will remain 0
    srcColor.a = 0.0f;
    vec4 final = vec4(0);
// this is going to be a lot of memory thruttling , 
// we could cut the frame buffer into a 4x4 grid quad (old optimization)

    final = combine_layer(backColor, srcColor);
    final = combine_layer(backColor2, final);
    final = combine_layer(backColor3, final);
   // final = combine_layer(backColor4, final);
   // final = combine_layer(frontColor4, final);
    final = combine_layer(frontColor3, final);

    final = combine_layer(frontColor2, final);

    final = combine_layer(frontColor, final);

    if(final.a <= 0.01f)
        discard;
  
    final.a = 1.0;
    gl_FragColor = final;
}
