$input a_position, a_texcoord0, a_normal
$output v_texcoord0, v_P_shadow, v_P_camera, v_P_clip, v_N, fs_positionInLightViewProjTexScale00, fs_positionInLightViewProjTexScale10, fs_positionInLightViewProjTexScale20, fs_positionInLightViewProjTexScale30

//@Aero LOGZ_VERTEX_DECLARE_FLOGZ
//@Aero LOGZ_VERTEX_DECLARE_FCOEF

//Light view projection matrices
//1 mat for each cascade split
uniform mat4 lvp[4];

void main()
{
  vec4 position = vec4(a_position, 1.0);
  vec4 position_clip =  mul(u_modelViewProj, position);
  vec4 position_camera = mul(u_modelView, position);
  vec4 position_world = mul(u_model[0], position);

  vec4 mesh_normal = vec4(a_normal, 0.0);
  vec4 camera_pos = mul(u_invView, vec4(0,0,0,1));

  vec4 normal_world = mul(u_model[0], mesh_normal);

  v_P_clip = position_clip.xyz;
  v_P_camera  = (position_world - camera_pos).xyz;
  v_P_camera = normalize(v_P_camera);
            
  //v_P_shadow = (world_to_shadow_matrix * model_matrix * position).xyz;
  v_N = normalize(normal_world.xyz);

  // shadow
  fs_positionInLightViewProjTexScale00 = mul(lvp[0], position_world);
  fs_positionInLightViewProjTexScale10 = mul(lvp[1], position_world);
  fs_positionInLightViewProjTexScale20 = mul(lvp[2], position_world);
  fs_positionInLightViewProjTexScale30 = mul(lvp[3], position_world);
  
  v_texcoord0 = a_texcoord0;
  v_P_shadow = vec3(0,0,0);

  gl_Position = position_clip;
  
  //@Aero LOGZ_VERTEX_ADJUST_GL_POSITION_Z
  //@Aero LOGZ_VERTEX_PASS_FLOGZ_AFTER_GL_POSITION
}
