$input v_texcoord0, v_P_shadow, v_P_camera, v_P_clip, v_N, fs_positionInLightViewProjTexScale00, fs_positionInLightViewProjTexScale10, fs_positionInLightViewProjTexScale20, fs_positionInLightViewProjTexScale30

//agf_include "color/hsv.inc"
//agf_include "color/srgb.inc"
//agf_include "color/tonemap_identity.inc"
//agf_include "logarithmic_z.inc"
//agf_include "math/env_map_math.inc"
//agf_include "math/perturb_normal.inc"
//agf_include "math/rand.inc"
//agf_include "materials/get_F0.inc"
//agf_include "materials/samplers_mdl.inc"
//agf_include "materials/shade.inc"

// material properties


// Sampler lookup calls //


SAMPLER2D(albedoMap, 0);
SAMPLER2D(emissiveMap, 1);
SAMPLER2D(opacityMap, 2);
SAMPLER2D(roughnessMap, 3);
SAMPLER2D(metalnessMap, 4);
SAMPLER2D(translucenceMap, 5);
SAMPLER2D(normalMap, 6);

uniform mat4 renderPassInputMat0;

uniform vec4 albedoValue;
uniform vec4 emissiveValue;
uniform vec4 opacityValue;
uniform vec4 roughnessValue;
uniform vec4 metalnessValue;
uniform vec4 translucenceValue;
uniform vec4 normalValue;

uniform mat4 albedoMapTransform;
uniform mat4 emissiveMapTransform;
uniform mat4 opacityMapTransform;
uniform mat4 roughnessMapTransform;
uniform mat4 metalnessMapTransform;
uniform mat4 translucenceMapTransform;
uniform mat4 normalMapTransform;

//uniform vec4 indexOfRefraction;
uniform vec4 renderPassInputVec0;
//uniform vec4 density;
uniform vec4 renderPassInputVec1;
//uniform vec4  interiorColor;
uniform vec4 renderPassInputVec2;

// daylight
//uniform vec4  daylight_sun_enabled;
//uniform vec4  daylight_color;
uniform vec4 renderPassInputVec3;

//uniform vec4  daylight_direction;
uniform vec4  renderPassInputVec4;

//uniform vec4  daylight_intensity;
//uniform vec4  daylight_cloudiness;
uniform vec4  renderPassInputVec5;

// @Aero ibl use Aero's for now
SAMPLER2D(brdf_map, 7);
SAMPLERCUBE(ibl_map, 8);

//uniform vec4 ibl_intensity;
//uniform vec4 ibl_color;
uniform vec4 renderPassInputVec6;
//uniform vec4 stochastic_transparency_rand_seed;
uniform vec4 renderPassInputVec7;

// ground plane
//uniform vec4 eye_space_ground_plane_equation;
uniform vec4 renderPassInputVec8;
//uniform vec4 ground_plane_occludes_objects;
//uniform vec4 ground_plane_occludes_objects;
// shadows
//agf_include "materials/shadow_support.inc"

// @Aero LOGZ_FRAGMENT_DECLARE_FLOGZ
// @Aero LOGZ_FRAGMENT_DECLARE_FCOEF_HALF

#define NUM_LIGHTS 1
Light lights[NUM_LIGHTS];

// ibl
//uniform vec4 ibl_max_levels;

#ifndef PI
#define PI 3.14159265359
#endif

float average(vec3 color) {
  // dot is faster than taking the average via addition and division. a dot is a single operation on some gpu's
  return dot(vec3_splat(0.3333), color);
}

/* Enable if IBL is equirect
vec3 sample_environment_equirect(vec3 N, float roughness) {
 vec3 ibl_Normal = (eye_space_normal_ibl_lookup_transformation_matrix*vec4(N, 0)).xyz;
  vec2 env_uv = normal_to_uv(ibl_Normal);
  vec3 sampledColor = texture2DLod(ibl_map, env_uv, roughness*ibl_max_levels).rgb;
  vec3 remappedColor = sampledColor * ibl_intensity;
  return remappedColor * ibl_color.rgb;
}
*/
/*
vec3 perturb_normal( vec3 Nvert, vec3 Nmap, vec3 V, vec2 texcoord ) {
  vec3 Nmap_flipped = Nmap;
  // green is up
  Nmap_flipped.y = -Nmap.y;

  if (dot(Nmap, Nmap) <= 0.0) {
    return Nvert;
  }
  vec3 normalized_mapped_normal = normalize(Nmap_flipped);
  mat3 TBN = cotangent_frame( Nvert, -V, texcoord );
  vec3 perturbedNormal = instMul(TBN, normalized_mapped_normal);

  if (dot(perturbedNormal, perturbedNormal) > 0.0) {
    return normalize(perturbedNormal);
  }

  return Nvert;
}
*/
vec3 sample_environment_cube(vec3 N, float roughness) {
  vec3 reflectionVector = normalize(instMul(renderPassInputMat0,vec4(N,0))).xyz * vec3(-1,1,1);
  //vec3 reflectionVector = N * vec3(-1,1,1);
  vec3 sampledColor = pow(textureCubeLod(ibl_map, reflectionVector, roughness * 10.0).rgb , vec3(0.8));
  vec3 remappedColor = sampledColor * renderPassInputVec6.w;
  return remappedColor * renderPassInputVec6.rgb;
}

vec2 get_specular_brdf(float roughness, vec3 N, vec3 V, vec3 vertex_normal) {
  // Horizon correction, per http://marmosetco.tumblr.com/post/81245981087
  const float horizon_amount = 1.3;
  vec3 reflected = normalize(reflect(-V,N));
  float horizon = clamp(1.0 + horizon_amount * dot(reflected, vertex_normal), 0.0, 1.0);
  horizon *= horizon;

  roughness = clamp(roughness, 0.05, 0.95 );
  float NdV = clamp(safe_dot(N, V), 0.05, 0.95 );
  vec2 brdf_uv = vec2(NdV, roughness);
  vec2 brdf = texture2D(brdf_map, brdf_uv).xy;
  return brdf.xy* horizon;
}

vec3 get_specular_ibl(vec3 specular_color, float roughness, vec3 N, vec3 V, vec2 brdf) 
{
  vec3 R = normalize(reflect(-V,N));
  vec3 color;
  {
    vec3 reflectionVector = normalize(instMul(renderPassInputMat0,vec4(R,0))).xyz * vec3(-1,1,1);
    //vec3 reflectionVector = N * vec3(-1,1,1);
    vec3 sampledColor = pow(textureCubeLod(ibl_map, reflectionVector, roughness * 10.0).rgb , vec3(0.8));
    vec3 remappedColor = sampledColor * renderPassInputVec6.w;
    color = remappedColor * renderPassInputVec6.rgb;
  }
  return color * (specular_color * brdf.xxx + brdf.yyy);
}



//////// CASCADED SHADOW MAP //////////////////
SAMPLER2DARRAY(shadowMap,9);
uniform vec4 cascadeZSplits;

float getShadowMask(float NdL)
{
   float dnGroundShadow = 0.0f;
   vec4 positionInShadowArray[4];
   positionInShadowArray[0] = fs_positionInLightViewProjTexScale00;
   positionInShadowArray[1] = fs_positionInLightViewProjTexScale10;
   positionInShadowArray[2] = fs_positionInLightViewProjTexScale20;
   positionInShadowArray[3] = fs_positionInLightViewProjTexScale30;
   // Pick proper cascade index
   vec4 posInClip = vec4(v_P_clip, 1.0);
   vec4 splits = cascadeZSplits; 
   int cascadeIndex = 0; 
   if (posInClip.z < splits.y) { cascadeIndex = 0; } 
   else if (posInClip.z < splits.z) { cascadeIndex = 1; } 
   else if (posInClip.z < splits.w) { cascadeIndex = 2; } 
   else{ cascadeIndex = 3;} 

   vec4 positionInShadow = positionInShadowArray[cascadeIndex]; 
   if (positionInShadow.z > 0.99999) return 0.0;

   vec2 shadowMapCoord = (vec2(positionInShadow.xy) + 1.0f) * 0.5f; 
   const float shadowOff = 1.0f / 2048.0f;
   const int shadowSamples = 5;
   vec2 sampleOffsets[shadowSamples];
   sampleOffsets[0] = vec2(shadowOff,shadowOff);
   sampleOffsets[1] = vec2(-shadowOff,shadowOff);
   sampleOffsets[2] = vec2(shadowOff,-shadowOff);
   sampleOffsets[3] = vec2(-shadowOff,-shadowOff);
   sampleOffsets[4] = vec2(0,0);
   float shadowMapDist;
   float occlusion = 0.0f;
   float distToLight = (positionInShadow.z + 1.0f) * 0.5f;
   float bias = 0.001f;

   for(int i = 0; i < shadowSamples; i++) { 
      shadowMapDist = texture2DArray( shadowMap,  vec3(shadowMapCoord.xy + sampleOffsets[i], cascadeIndex)).r; 
      occlusion += step(0.0, distToLight - shadowMapDist - bias);  
   }

   dnGroundShadow = occlusion / float(shadowSamples);
   float shadow_coverage = dnGroundShadow;
   float shadow_opacity = 0.5f;
   return shadow_opacity * step(0.5, shadow_coverage) * shadow_coverage;
}
///////////////////////////////////////////////

void main() {

  //########################################## CLIPPING PLANES ################################################################################
  float clipSign = dot(renderPassInputVec8.xyz, v_P_camera.xyz)+renderPassInputVec8.w;

  // V, for all intents and purposes, should be Vcamera in a fragment shader
  vec3 Vcamera = normalize(-v_P_camera);
  vec3 V = Vcamera;

  lights[0].dir = normalize(renderPassInputVec4.xyz);
  lights[0].color = renderPassInputVec3.rgb;
  lights[0].intensity = renderPassInputVec5.r;
  lights[0].radius = renderPassInputVec5.g;

  // used to determine horizon for IBL correction. should be raw fragment normal, not changed by texture maps.
  vec3 Nvert = normalize(v_N);
  vec3 N = Nvert;

  vec2 duv1 = dFdx( v_texcoord0 );
  vec2 duv2 = dFdy( v_texcoord0 );

  bool badUV = ((duv1.x == 0.0) && (duv1.y == 0.0) && (duv2.x == 0.0) && (duv2.y == 0.0));
  if ((badUV == false)) {
    SAMPLE_MDL_NORMAL(normal, v_texcoord0);
    vec3 Nmap = USE_MDL_SAMPLER(normal) ? normalResult : vec3(0,0,1);
    Nmap.g = -Nmap.g;
    N = perturb_normal(Nvert, Nmap, Vcamera, v_texcoord0);
  }
  //world N
  //N = instMul(renderPassInputMat0,vec4(N,0))).xyz;

  SAMPLE_MDL_COLOR(albedo, v_texcoord0);
  vec4 base_color = USE_MDL_SAMPLER(albedo) ? albedoResult : albedoValue;
  vec3 base_color_linear = USE_MDL_SAMPLER(albedo) ? srgb_to_linear(base_color.rgb) : base_color.rgb;

  // reflectivity is the reflectance at normal incidence. should be ~4-8% for most materials, corresponding to
  // an index_of_refraction 1-3 range
  // https://en.wikipedia.org/wiki/Refractive_index#Reflectivity
  float ior = renderPassInputVec0.r;
  // float reflectivity = pow(abs((1.0 - ior) / (1.0 + ior)), 2.0); // 0.04 when ior is 1.4
  float reflectivity = 0.08;

  SAMPLE_MDL_SCALAR(metalness, v_texcoord0);
  float metallic_scalar =  USE_MDL_SAMPLER(metalness) ? metalnessResult : metalnessValue.x;
  // F0 is the amount of light reflected at normal incidence (ie, NdV = 0)
  // TODO: technically, I think we can derive this 0.08 constant from ior. 0.02-0.08 are most common values. 0.04 is plastic.
  vec3 F0 = mix(vec3_splat(reflectivity), base_color_linear, metallic_scalar);

  SAMPLE_MDL_SCALAR(roughness, v_texcoord0);
  float roughness = USE_MDL_SAMPLER(roughness) ? roughnessResult : roughnessValue.x;

  // unlit
  vec3 accumulated_light = vec3(0.0, 0.0, 0.0);

  //
  // Directional lighting
  //
  float NdL = safe_dot(N, lights[0].dir);
  NdL = min(NdL, 0.99);  // prevents weird anomaly when normal and light are coincident - atan2 issue?
  float shadowMask = getShadowMask(NdL); // @Aero get_shadow(NdL, v_P_shadow);
  vec3 iblColorHSV = rgb_to_hsv(renderPassInputVec6.rgb);
  float adjustedAmbientIntensity = renderPassInputVec6.w * iblColorHSV.b;
  float iblIntensityMult = adjustedAmbientIntensity * 0.25;
  vec3 sun = vec3(0);
  if (renderPassInputVec3.w != 0) {
    float horizonEdge = clipSign * dot(normalize(reflect(-V,N)), renderPassInputVec8.xyz);
    Material material;
    material.metalicity = metallic_scalar;
    material.roughness = roughness;
    material.base_color = base_color_linear;
    material.F0 = F0;

    sun = sun_shade(lights[0], V, N, horizonEdge, material);
    float cloudinessMult = 1 - renderPassInputVec5.g * 0.85; //leave a little shadow even if cloudy
    shadowMask *= cloudinessMult;
    accumulated_light += sun * (1 - shadowMask);
    shadowMask = 1.0f; //The rest of the light is IBL which we will not have a shadow for
    iblIntensityMult *= 0.33;  //tone down IBL if theres sun - does funky things otherwise
  }
  else {
    shadowMask *= NdL; // fade shadows out on sides of objects (prevents shadow acne)
  }
  float ibl_visibility = 1.0 - (clamp(iblIntensityMult, 0.0, 1.0) * shadowMask);

  vec2 specular_bsdf = get_specular_brdf(roughness, N, V, Nvert); //@Aero

  // Transmittance
  SAMPLE_MDL_SCALAR(translucence, v_texcoord0);
  float translucence_scalar = USE_MDL_SAMPLER(translucence) ? translucenceResult : translucenceValue.x;
  // modulate stochastic refraction effect so that fresnel component is non-transmittant -- the edge reflect more light
  // so don't fake refraction there.
  float transmittance = translucence_scalar * specular_bsdf.x;
  float refr_opacity = 1.0;

  //
  // Front-facing surface shading with IBL contribution (and back-facing surface shading when there is no refraction)
  //
  float NdV = dot(N,V);
  vec3 diffuse_light = vec3(0);
  vec3 reflected_light = vec3(0);
  if( NdV >= 0.0 || translucence_scalar < 0.01) {
    // diffuse
    float diffuse_energy = (1.0 - reflectivity) * (1.0 - metallic_scalar) * 2.0 / PI;
    vec3 diffuseIBL = (sample_environment_cube(N, 0.9)); //@Aero
    diffuse_light = base_color_linear * diffuseIBL * vec3_splat(diffuse_energy);
    accumulated_light += (1.0 - transmittance) * diffuse_light * ibl_visibility;

    // reflection
    reflected_light = get_specular_ibl(F0, roughness, N, V, specular_bsdf); //@Aero
    accumulated_light += reflected_light * ibl_visibility;

    //
    // Emission
    //
    // energy used for opacity calc
    SAMPLE_MDL_SCALAR(emissive, v_texcoord0);
    float emitted_energy = USE_MDL_SAMPLER(emissive) ? emissiveResult : emissiveValue.x;
    vec3 glow_linear = base_color_linear * emitted_energy;
    accumulated_light += glow_linear;

    //
    // Refraction (front-facing surface)
    //
    if (translucence_scalar > 0.01) {
      // Scattering contribution -- guaranteed to be [0.0,1.0)
      float scattering = 0.0;
      if (renderPassInputVec1.r>0.0)
        scattering = pow(0.5, 1.0 / renderPassInputVec1.r);

      // refr_opacity is the probability the light will not make it to the backface surface
      refr_opacity = mix( clamp(1.0 - transmittance + reflectivity, 0.0, 1.0), 1.0, scattering );

      // interior color contributes according to density and transmittance
      vec3 refr_color = mix(diffuse_light * vec3_splat(1.0 - transmittance), diffuse_light * srgb_to_linear(renderPassInputVec2.rgb), scattering * transmittance );

      // front face surface accumulation
      accumulated_light += refr_color * transmittance;
    }
  } else {
    //
    // Backface rendering when there is refraction (for stochastic refraction hackery)
    // This is a tricky hack to make translucent objects look translucent...
    //

    // always permit half of the rays through so that the user can see surfaces behind this one
    // rough transparent objects are more or less opaque
    refr_opacity = clamp((1.0 + roughness) / 2.0, 0.0, 1.0);

    // We can't know how the real rays would have bounced around the object, but if we pretend the object
    // is a unit sphere, we can approximate the refraction of round objects

    // Calculate normal of entry point (if the object was a unit sphere)... remember this is the back face
    vec3 Nfront = -normalize(reflect(-N, -V));

    // Figure out transmitted exit vector of both front and back surface
    vec3 T = double_refract(-V, Nfront, ior);

    // Sample environment in refracted direction
    vec3 refr_color = base_color_linear * sample_environment_cube(T, roughness); // @Aero

    // backface refracted color supersedes accumulated color -- we don't do surface shading on backfaces
    accumulated_light = refr_color;
  }

  // uncomment to debug front face shading
  // refr_opacity = (NdV >= 0.0) ? 1.0 : 0.0;

  // uncomment to debug back face shading
  // refr_opacity = (NdV >= 0.0) ? 0.0 : 1.0;

  // Sampling opacity: opacity map is a color texture, so we pick a max out of the components to get a single value
  SAMPLE_MDL_SCALAR(opacity, v_texcoord0);
  float base_opacity = USE_MDL_SAMPLER(opacity) ? opacityResult : opacityValue.x;

  // initial opacity is either the base opacity, or the opacity from refraction
  float final_opacity = base_opacity * refr_opacity;

  if (renderPassInputVec7.r>0.0) {
    //Stochastic transparency. Code can be put anywhere after opacity math is done and result is in 'final_opacity'
    float heisenbergOpacity = rand(gl_FragCoord.xy + v_P_clip.zz + vec2(renderPassInputVec7.r,renderPassInputVec7.r));

    float testOpacity = final_opacity;

    if (testOpacity < 0.05) {
      testOpacity = 0.1*final_opacity;
    }

    if (heisenbergOpacity > testOpacity) {
      discard;
    }

    final_opacity = 1.0;
  }

  // fragColor = vec4(linear_to_srgb(base_color_linear), final_opacity);
  // fragColor = vec4(vec3(safe_dot(N, Vclip)), final_opacity);
  vec3 reflectionVector = normalize(reflect(-V,N));
  vec3 sampledColor = pow(textureCubeLod(ibl_map, reflectionVector, roughness * 9.0).rgb , vec3(0.8));
  gl_FragColor = saturate(vec4(linear_to_srgb(tonemap(accumulated_light)), final_opacity)) + vec4( sampledColor, 1.0)*0.0;
  //gl_FragColor += vec4(specular_bsdf,0,1);
  //@Aero LOGZ_FRAGMENT_ADJUST_DEPTH_WITH_FLOGZ_FCOEF

  // Debug IBL:
  // fragColor = vec4(linear_to_srgb(get_specular_ibl(brdf_map, ibl_map, eye_space_normal_ibl_lookup_transformation_matrix, vec3(1.0), roughness, N, V, specular_bsdf)), 1.0);
  // Debug normal map:
  // gl_FragColor = vec4(Nmap/2.0 + vec3(0.5), 1.0) + gl_FragColor*0.000001;
  // Debug normals:
  // fragColor = vec4(N/2.0 + vec3(0.5), 1.0);
}
