/* API Version - 2.2.2 */

/**
 * Instances of this interface represent time signature values.
 *
 * @since API version 1
 */
function TimeSignatureValue() {}

TimeSignatureValue.prototype = new Value();
TimeSignatureValue.prototype.constructor = TimeSignatureValue;

/**
 * Gets the current value.
 *
 * @return {string}
 * @since API version 2
 */
TimeSignatureValue.prototype.get = function() {};

/**
 * Updates the time signature according to the given string.
 *
 * @param name
          a textual representation of the new time signature value, formatted as
          `numerator/denominator[, ticks]`
 * @since API version 1
 */
TimeSignatureValue.prototype.set = function(name) {};

/**
 * Returns an object that provides access to the time signature numerator.
 *
 * @return {com.bitwig.extension.controller.api.SettableIntegerValue} an integer value object that represents the time signature numerator.
 * @since API version 1
 */
TimeSignatureValue.prototype.getNumerator = function() {};

/**
 * Returns an object that provides access to the time signature denominator.
 *
 * @return {com.bitwig.extension.controller.api.SettableIntegerValue} an integer value object that represents the time signature denominator.
 * @since API version 1
 */
TimeSignatureValue.prototype.getDenominator = function() {};

/**
 * Returns an object that provides access to the time signature tick subdivisions.
 *
 * @return {com.bitwig.extension.controller.api.SettableIntegerValue} an integer value object that represents the time signature ticks.
 * @since API version 1
 */
TimeSignatureValue.prototype.getTicks = function() {};
