${setOutputPath(info.fileName + ".control.js")}<#rt>
loadAPI(${info.requiredAPIVersion});

// Remove this if you want to be able to use deprecated methods without causing script to stop.
// This is useful during development.
host.setShouldFailOnDeprecatedUse(true);

host.defineController("${info.vendor?j_string}", "${info.name?j_string}", "${info.version?j_string}", "${info.extensionIdString?j_string}", "${info.author?j_string}");
<#if info.numMidiInPorts gt 0 || info.numMidiOutPorts gt 0>

host.defineMidiPorts(${info.numMidiInPorts}, ${info.numMidiOutPorts});

if (host.platformIsWindows())
{
   // TODO: Set the correct names of the ports for auto detection on Windows platform here
   // and uncomment this when port names are correct.
   // host.addDeviceNameBasedDiscoveryPair([<#rt>
   <#list 0..(info.numMidiInPorts - 1) as input><#t>
   "Input Port ${input}"<#if input_has_next>, </#if><#t>
   </#list><#t>
   ], [<#t>
   <#list 0..(info.numMidiOutPorts - 1) as output>
   "Output Port ${output}"<#if output_has_next>, </#if><#t>
   </#list><#t>
   ]);<#lt>
}
else if (host.platformIsMac())
{
   // TODO: Set the correct names of the ports for auto detection on Mac OSX platform here
   // and uncomment this when port names are correct.
   // host.addDeviceNameBasedDiscoveryPair([<#rt>
   <#list 0..(info.numMidiInPorts - 1) as input><#t>
   "Input Port ${input}"<#if input_has_next>, </#if><#t>
   </#list><#t>
   ], [<#t>
   <#list 0..(info.numMidiOutPorts - 1) as output>
   "Output Port ${output}"<#if output_has_next>, </#if><#t>
   </#list><#t>
   ]);<#lt>
}
else if (host.platformIsLinux())
{
   // TODO: Set the correct names of the ports for auto detection on Linux platform here
   // and uncomment this when port names are correct.
   // host.addDeviceNameBasedDiscoveryPair([<#rt>
   <#list 0..(info.numMidiInPorts - 1) as input><#t>
   "Input Port ${input}"<#if input_has_next>, </#if><#t>
   </#list><#t>
   ], [<#t>
   <#list 0..(info.numMidiOutPorts - 1) as output>
   "Output Port ${output}"<#if output_has_next>, </#if><#t>
   </#list><#t>
   ]);<#lt>
}
</#if>

function init() {
<#if info.numMidiInPorts gt 0>
   transport = host.createTransport();
   <#list 0..(info.numMidiInPorts - 1) as i>
   host.getMidiInPort(${i}).setMidiCallback(onMidi${i});
   host.getMidiInPort(${i}).setSysexCallback(onSysex${i});
   </#list>
</#if>

   // TODO: Perform further initialization here.
   println("${info.name?j_string} initialized!");
}

<#if info.numMidiInPorts gt 0>
   <#list 0..(info.numMidiInPorts - 1) as i>
// Called when a short MIDI message is received on MIDI input port ${i}.
function onMidi${i}(status, data1, data2) {
   // TODO: Implement your MIDI input handling code here.
}

// Called when a MIDI sysex message is received on MIDI input port ${i}.
function onSysex${i}(data) {
<#if i == 0>
   // MMC Transport Controls:
   switch (data) {
      case "f07f7f0605f7":
         transport.rewind();
         break;
      case "f07f7f0604f7":
         transport.fastForward();
         break;
      case "f07f7f0601f7":
         transport.stop();
         break;
      case "f07f7f0602f7":
         transport.play();
         break;
      case "f07f7f0606f7":
         transport.record();
         break;
   }
</#if>
}
   </#list>
</#if>

function flush() {
   // TODO: Flush any output to your controller here.
}

function exit() {

}