${setOutputPath(info.packageName?replace(".", "/") + "/" + info.className + "ExtensionDefinition.java")}<#rt>
package ${info.packageName};
import java.util.UUID;

import com.bitwig.extension.api.PlatformType;
import com.bitwig.extension.controller.AutoDetectionMidiPortNamesList;
import com.bitwig.extension.controller.ControllerExtensionDefinition;
import com.bitwig.extension.controller.api.ControllerHost;

public class ${info.className}ExtensionDefinition extends ControllerExtensionDefinition
{
   private static final UUID DRIVER_ID = UUID.fromString("${info.extensionIdString?j_string}");
   
   public ${info.className}ExtensionDefinition()
   {
   }

   @Override
   public String getName()
   {
      return "${info.name?j_string}";
   }
   
   @Override
   public String getAuthor()
   {
      return "${info.author?j_string}";
   }

   @Override
   public String getVersion()
   {
      return "${info.version?j_string}";
   }

   @Override
   public UUID getId()
   {
      return DRIVER_ID;
   }
   
   @Override
   public String getHardwareVendor()
   {
      return "${info.vendor?j_string}";
   }
   
   @Override
   public String getHardwareModel()
   {
      return "${info.name?j_string}";
   }

   @Override
   public int getRequiredAPIVersion()
   {
      return ${info.requiredAPIVersion};
   }

   @Override
   public int getNumMidiInPorts()
   {
      return ${info.numMidiInPorts};
   }

   @Override
   public int getNumMidiOutPorts()
   {
      return ${info.numMidiOutPorts};
   }

   @Override
   public void listAutoDetectionMidiPortNames(final AutoDetectionMidiPortNamesList list, final PlatformType platformType)
   {
<#if info.numMidiInPorts gt 0 || info.numMidiOutPorts gt 0>
      if (platformType == PlatformType.WINDOWS)
      {
         // TODO: Set the correct names of the ports for auto detection on Windows platform here
         // and uncomment this when port names are correct.
         // list.add(new String[]{<#rt>
         <#list 0..(info.numMidiInPorts - 1) as input><#t>
         "Input Port ${input}"<#if input_has_next>, </#if><#t>
         </#list><#t>
         }, new String[]{<#t>
         <#list 0..(info.numMidiOutPorts - 1) as output>
         "Output Port ${output}"<#if output_has_next>, </#if><#t>
         </#list><#t>
         });<#lt>
      }
      else if (platformType == PlatformType.MAC)
      {
         // TODO: Set the correct names of the ports for auto detection on Windows platform here
         // and uncomment this when port names are correct.
         // list.add(new String[]{<#rt>
         <#list 0..(info.numMidiInPorts - 1) as input><#t>
         "Input Port ${input}"<#if input_has_next>, </#if><#t>
         </#list><#t>
         }, new String[]{<#t>
         <#list 0..(info.numMidiOutPorts - 1) as output>
         "Output Port ${output}"<#if output_has_next>, </#if><#t>
         </#list><#t>
         });<#lt>
      }
      else if (platformType == PlatformType.LINUX)
      {
         // TODO: Set the correct names of the ports for auto detection on Windows platform here
         // and uncomment this when port names are correct.
         // list.add(new String[]{<#rt>
         <#list 0..(info.numMidiInPorts - 1) as input><#t>
         "Input Port ${input}"<#if input_has_next>, </#if><#t>
         </#list><#t>
         }, new String[]{<#t>
         <#list 0..(info.numMidiOutPorts - 1) as output>
         "Output Port ${output}"<#if output_has_next>, </#if><#t>
         </#list><#t>
         });<#lt>
      }
</#if>
   }

   @Override
   public ${info.className}Extension createInstance(final ControllerHost host)
   {
      return new ${info.className}Extension(this, host);
   }
}
