/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.geom.WLc;
import com.bitwig.graphics.WxX;
import com.bitwig.graphics.hLE;
import com.bitwig.win32_windowing_system.UCU;
import com.bitwig.win32_windowing_system.UVl;
import com.bitwig.win32_windowing_system.Win32DIBSectionMemoryBlock;
import com.bitwig.win32_windowing_system.Win32TopLevelWindowHandle;
import java.util.List;

class Win32DoubleBuffer
extends UCU {
    private final long nfh;
    private final UVl jtS;

    public Win32DoubleBuffer(Win32TopLevelWindowHandle win32TopLevelWindowHandle) {
        super(win32TopLevelWindowHandle);
        long l2 = win32TopLevelWindowHandle.qpf();
        Win32DIBSectionMemoryBlock win32DIBSectionMemoryBlock = Win32DIBSectionMemoryBlock.Gnn(l2, this.Gqs, this.DmN);
        this.nfh = win32DIBSectionMemoryBlock.Wcd();
        this.jtS = new UVl((com.bitwig.base.platform.UCU)win32DIBSectionMemoryBlock, win32TopLevelWindowHandle.mE, this.Gqs, this.DmN, win32TopLevelWindowHandle.dTJ() ? hLE.Gnn : hLE.Gqs, true);
    }

    @Override
    public void Gnn() {
        this.jtS.gj_();
    }

    @Override
    public WxX pQJ() {
        return this.jtS.Gqs();
    }

    @Override
    public void Gnn(List list, boolean bl2) {
        if (this.Gnn.dTJ()) {
            Win32DoubleBuffer.blitToScreenWithAlphaNative(this.nfh, this.Gnn.qpf(), 0, 0, this.Gnn.AE_(), this.Gnn.AD_());
        } else {
            for (WLc wLc : list) {
                assert (cNU.Gnn(wLc != null));
                assert (cNU.Gqs(!wLc.Gqs()));
                this.Gqs(wLc.mE(), wLc.agl(), wLc.kPs(), wLc.iur());
            }
        }
    }

    @Override
    public void Gnn(int n2, int n4, int n5, int n6) {
        this.Gqs(n2, n4, n5, n6);
    }

    private void Gqs(int n2, int n4, int n5, int n6) {
        assert (cNU.Gqs(n2 >= 0));
        assert (cNU.Gqs(n4 >= 0));
        assert (cNU.Gqs(n2 + n5 <= this.qpf));
        assert (cNU.Gnn(n4 + n6 <= this.Wcd));
        Win32DoubleBuffer.blitToScreenNative(this.nfh, this.Gnn.qpf(), n2, n4, n5, n6);
    }

    private static native void blitToScreenNative(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native void blitToScreenWithAlphaNative(long var0, long var2, int var4, int var5, int var6, int var7);
}

