/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.platform.UCU;
import java.nio.ByteBuffer;

public class Win32DIBSectionMemoryBlock
extends UCU {
    private long qpf = Win32DIBSectionMemoryBlock.getLastHBitmapNative();

    protected Win32DIBSectionMemoryBlock(long l2, int n2, int n4, int n5) {
        super(Win32DIBSectionMemoryBlock.Gqs(l2, n2, n4), n5);
    }

    public static Win32DIBSectionMemoryBlock Gnn(long l2, int n2, int n4) {
        int n5 = Win32DIBSectionMemoryBlock.Gnn(n2, n4);
        return new Win32DIBSectionMemoryBlock(l2, n2, n4, n5);
    }

    @Override
    public void qpf() {
        assert (cNU.Gnn(!this.DmN()));
        if (this.Gnn != null) {
            Win32DIBSectionMemoryBlock.releaseNative(this.qpf);
            super.qpf();
            this.qpf = 0L;
            assert (cNU.Gnn(this.Gnn == null));
        }
        assert (cNU.Gnn(this.qpf == 0L));
    }

    private static int Gnn(int n2, int n4) {
        return n2 * n4 * 4;
    }

    private static ByteBuffer Gqs(long l2, int n2, int n4) {
        ByteBuffer byteBuffer = Win32DIBSectionMemoryBlock.createNative(l2, n2, n4);
        if (byteBuffer == null) {
            throw new OutOfMemoryError("Could not allocate native memory block");
        }
        return byteBuffer;
    }

    public long Wcd() {
        return this.qpf;
    }

    private static native ByteBuffer createNative(long var0, int var2, int var3);

    private static native long getLastHBitmapNative();

    private static native void releaseNative(long var0);
}

