/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.graphics.WxX;
import com.bitwig.win32_windowing_system.Win32TitledWindowHandle;
import com.bitwig.win32_windowing_system.Win32TopLevelWindowHandle;
import java.util.List;

abstract class UCU {
    protected final Win32TopLevelWindowHandle Gnn;
    protected final int Gqs;
    protected final int DmN;
    protected int qpf;
    protected int Wcd;

    protected UCU(Win32TopLevelWindowHandle win32TopLevelWindowHandle) {
        this.Gnn = win32TopLevelWindowHandle;
        this.qpf = win32TopLevelWindowHandle.AE_();
        this.Wcd = win32TopLevelWindowHandle.AD_();
        if (win32TopLevelWindowHandle instanceof Win32TitledWindowHandle) {
            this.Gqs = (this.qpf / 16 + 1) * 16;
            this.DmN = (this.Wcd / 16 + 1) * 16;
        } else {
            this.Gqs = Math.max(1, this.qpf);
            this.DmN = Math.max(1, this.Wcd);
        }
        assert (cNU.Gnn(this.qpf <= this.Gqs));
        assert (cNU.Gnn(this.Wcd <= this.DmN));
    }

    public abstract void Gnn();

    public final int Gqs() {
        return this.Gqs;
    }

    public final int DmN() {
        return this.DmN;
    }

    public final int qpf() {
        return this.qpf;
    }

    public final int Wcd() {
        return this.Wcd;
    }

    final void Gnn(int n2, int n4) {
        assert (cNU.Gqs(n2 >= 0));
        assert (cNU.Gqs(n2 <= this.Gqs));
        assert (cNU.Gqs(n4 >= 0));
        assert (cNU.Gqs(n4 <= this.DmN));
        this.qpf = n2;
        this.Wcd = n4;
    }

    public abstract WxX pQJ();

    public abstract void Gnn(List var1, boolean var2);

    public abstract void Gnn(int var1, int var2, int var3, int var4);
}

