/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceString;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.IntelligentControlSurfaceString;
import com.bitwig.flt.control_surface.values.StringValueProxy$1;
import com.bitwig.flt.control_surface.values.StringValueProxy$2;
import com.bitwig.flt.control_surface.values.ValueProxy;

public class StringValueProxy
extends ValueProxy
implements Seo,
StringValue {
    private ControlSurfaceString mValue;
    private final ControlSurfaceString mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createControlSurfaceStringValue(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return YOb.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (cNz.DmN(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new StringValueProxy$1(this, stringValueChangedCallback));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new StringValueProxy$2(this, stringValueChangedCallback, string, n2));
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(YOb yOb) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(yOb != null));
        yOb.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(YOb yOb) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(yOb != null));
        assert (cNz.DmN(this.isInterested()));
        assert (cNz.DmN(this.isActiveOnDocumentThread()));
        yOb.addListener(this);
        this.updateValue();
    }

    public ControlSurfaceString getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(zuh zuh2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(this.getTarget() != null));
        assert (cNz.DmN(this.isInterested()));
        assert (cNz.DmN(yLr.Gnn(zuh2.Gnn(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (cNz.DmN(this.isDocumentThread()));
        String string = (String)((YOb)this.getTarget()).getValue();
        assert (cNz.DmN(string != null));
        ControlSurfaceString controlSurfaceString = this.createControlSurfaceStringValue(string);
        assert (cNz.DmN(controlSurfaceString != null));
        this.queueNotifyObservers(controlSurfaceString);
    }

    private void queueNotifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(controlSurfaceString));
    }

    protected ControlSurfaceString createControlSurfaceStringValue(String string) {
        assert (cNz.DmN(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return ControlSurfaceString.EMPTY;
        }
        return new IntelligentControlSurfaceString(string);
    }

    private void notifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        assert (cNz.DmN(this.isInterested()));
        if (!controlSurfaceString.equals(this.mValue)) {
            this.mValue = controlSurfaceString;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(controlSurfaceString);
                }
            }
        }
    }

    static /* synthetic */ ControlSurfaceString access$000(StringValueProxy stringValueProxy) {
        return stringValueProxy.mDefaultValue;
    }
}

