/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SignalProxy;
import com.bitwig.ramona.core.cKQ;

public class SignalSetting
extends SignalProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final String mAction;
    private Ovv mIsEnabled;
    private Ovv mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private cKQ mSetting;

    public SignalSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new wJp("Error: label for setting can't be empty.");
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mAction = string3;
    }

    public void connectToSetting(PK pK2) {
        assert (cNz.qpf(this.mSetting == null));
        this.mSetting = pK2;
        this.setTarget(pK2.jtS());
        this.connectEnableAndVisibleValues(pK2.gqj(), pK2.LDt());
    }

    public void disconnectFromSetting(PK pK2) {
        assert (cNz.qpf(this.mSetting == pK2));
        this.disconnectEnableAndVisibleValues(pK2.gqj(), pK2.LDt());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(SNL sNL) {
        assert (cNz.qpf(this.mSetting == null));
        this.mSetting = sNL;
        this.setTarget(sNL.Gqs());
        this.connectEnableAndVisibleValues(sNL.dTJ(), sNL.nfh());
    }

    public void disconnectFromSetting(SNL sNL) {
        assert (cNz.qpf(this.mSetting == sNL));
        this.disconnectEnableAndVisibleValues(sNL.dTJ(), sNL.nfh());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(Ovv ovv, Ovv ovv2) {
        this.mIsEnabled = ovv;
        this.mIsVisible = ovv2;
    }

    private void disconnectEnableAndVisibleValues(Ovv ovv, Ovv ovv2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public String getAction() {
        return this.mAction;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        if (this.mIsVisible != null) {
            this.mIsVisible.setValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public cKQ getSetting() {
        return this.mSetting;
    }
}

