/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy;
import com.bitwig.flt.control_surface.values.DocumentNumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.NumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.PreferencesNumberSettingRangedValueTarget;
import com.bitwig.ramona.core.cKQ;

public class NumberSetting
extends AbstractRangedValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final double mMinValue;
    private final double mMaxValue;
    private final double mStepResolution;
    private final String mUnit;
    private final double mDefaultValue;
    private Ovv mIsEnabled;
    private Ovv mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private cKQ mSetting;

    public NumberSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, double d3, double d4, double d5, String string3, double d6) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new wJp("Error: label for setting can't be empty.");
        }
        if (string3 == null) {
            string3 = "";
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mMinValue = d3;
        this.mMaxValue = d4;
        this.mStepResolution = d5;
        this.mUnit = string3;
        this.mDefaultValue = d6;
        this.setKey("Setting/" + string2 + "/" + string);
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    @Override
    public Class getTargetType() {
        return NumberSettingRangedValueTarget.class;
    }

    public void connectToSetting(Py py2) {
        assert (cNz.qpf(this.mSetting == null));
        this.mSetting = py2;
        this.setTarget(new PreferencesNumberSettingRangedValueTarget(py2));
        this.connectEnableAndVisibleValues(py2.gqj(), py2.LDt());
    }

    public void disconnectFromSetting(Py py2) {
        assert (cNz.qpf(this.mSetting == py2));
        this.disconnectEnableAndVisibleValues(py2.gqj(), py2.LDt());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(XZo xZo) {
        assert (cNz.qpf(this.mSetting == null));
        this.mSetting = xZo;
        this.setTarget(new DocumentNumberSettingRangedValueTarget(xZo));
        this.connectEnableAndVisibleValues(xZo.dTJ(), xZo.nfh());
    }

    public void disconnectFromSetting(XZo xZo) {
        assert (cNz.qpf(this.mSetting == xZo));
        this.disconnectEnableAndVisibleValues(xZo.dTJ(), xZo.nfh());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(Ovv ovv, Ovv ovv2) {
        this.mIsEnabled = ovv;
        this.mIsVisible = ovv2;
    }

    private void disconnectEnableAndVisibleValues(Ovv ovv, Ovv ovv2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    protected double getCurrentValue() {
        double d3 = super.getCurrentValue();
        int n2 = (int)Math.round(d3 / this.mStepResolution);
        return this.mStepResolution * (double)n2;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public double getStepResolution() {
        return this.mStepResolution;
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        if (this.mIsVisible != null) {
            this.mIsVisible.setValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public cKQ getSetting() {
        return this.mSetting;
    }
}

