/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;

public class ListValueLengthProxy
extends ValueProxy
implements cZI,
IntegerValue {
    private List mUnassignedObservers;
    private boolean mHasScheduledUpdateCount;
    private int mValue;

    public ListValueLengthProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public Class getTargetType() {
        return gBF.class;
    }

    @Override
    public int get() {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        if (n2 == 0) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n2));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(0);
    }

    protected void connectToTarget(gBF gBF2) {
        gBF2.Gnn(this);
    }

    protected void disconnectFromTarget(gBF gBF2) {
        gBF2.Gqs(this);
    }

    @Override
    public void addedAsListenerTo(gBF gBF2) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(gBF gBF2) {
        this.scheduleUpdateCount();
    }

    @Override
    public void insertedItems(gBF gBF2, int n2, int n4) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToRemoveItems(gBF gBF2, int n2, int n4) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToChangeItems(gBF gBF2, int n2, int n4) {
        this.scheduleUpdateCount();
    }

    @Override
    public void changedItems(gBF gBF2, int n2, int n4) {
    }

    private void scheduleUpdateCount() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateCount) {
            this.mHasScheduledUpdateCount = true;
            this.runAtEndOfEvent(this::updateCount);
        }
    }

    private void updateCount() {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(this.mHasScheduledUpdateCount));
        this.mHasScheduledUpdateCount = false;
        gBF gBF2 = (gBF)this.getTarget();
        if (gBF2 != null) {
            this.queueNotifyObservers(gBF2.Gqs());
        } else {
            this.queueNotifyObserversUnassigned();
        }
    }

    private void queueNotifyObserversUnassigned() {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(0, false));
    }

    private void queueNotifyObservers(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(n2, true));
    }

    private void notifyObservers(int n2, boolean bl2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        assert (cNz.DmN(this.isInterested()));
        assert (cNz.DmN(!bl2 ? n2 == 0 : true));
        if (n2 != this.mValue) {
            this.mValue = n2;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n2);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n2);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

