/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.EnumValueChangedCallback;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;

public class EnumValueProxy
extends ValueProxy
implements Seo,
SettableEnumValue {
    private String mValue;
    private final String mInitialValue;
    private final String[] mOptions;

    public EnumValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray, String string) {
        super(controlSurfaceObject);
        assert (cNz.DmN(stringArray != null));
        assert (cNz.qpf(stringArray.length > 0));
        this.mOptions = stringArray;
        this.mInitialValue = string;
        this.mValue = string;
    }

    @Override
    public Class getTargetType() {
        return YOb.class;
    }

    public void addValueObserver(EnumValueChangedCallback enumValueChangedCallback) {
        this.doAddValueObserver(enumValueChangedCallback);
    }

    protected void sendDefaultValue(EnumValueChangedCallback enumValueChangedCallback) {
        enumValueChangedCallback.valueChanged(this.mInitialValue);
    }

    @Override
    public void set(String string) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (string == null) {
            throw new wJp("value cannot be null");
        }
        this.exec(() -> this.doSet(string));
    }

    private void doSet(String string) {
        assert (cNz.DmN(this.isDocumentThread()));
        YOb yOb = (YOb)this.getTarget();
        if (yOb != null) {
            yOb.setValue(string);
        }
    }

    protected void disconnectFromTarget(YOb yOb) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(yOb != null));
        yOb.removeListener(this);
        this.queueNotifyObservers(this.mInitialValue);
    }

    protected void connectToTarget(YOb yOb) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(yOb != null));
        yOb.addListener(this);
        this.queueNotifyObservers((String)yOb.getValue());
    }

    public String[] getOptions() {
        return this.mOptions;
    }

    public String getDefaultValue() {
        return this.mInitialValue;
    }

    public void eventOccurred(zuh zuh2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(this.getTarget() != null));
        assert (cNz.DmN(this.isInterested()));
        assert (cNz.DmN(yLr.Gnn(zuh2.Gnn(), this.getTarget())));
        String string = (String)((YOb)this.getTarget()).getValue();
        this.queueNotifyObservers(string);
    }

    private void queueNotifyObservers(String string) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(string));
    }

    private void notifyObservers(String string) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        assert (cNz.DmN(this.isInterested()));
        if (!string.equals(this.mValue)) {
            this.mValue = string;
            if (this.mObservers != null) {
                for (EnumValueChangedCallback enumValueChangedCallback : this.mObservers) {
                    enumValueChangedCallback.valueChanged(string);
                }
            }
        }
    }

    @Override
    public String get() {
        assert (cNz.Gnn(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }
}

