/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumValueProxy;
import com.bitwig.ramona.core.cKQ;

public class EnumSetting
extends EnumValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private Ovv mIsEnabled;
    private Ovv mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private cKQ mSetting;

    public EnumSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String[] stringArray, String string3) {
        super(controlSurfaceObject, stringArray, string3);
        if (string == null || string.isEmpty()) {
            throw new wJp("Error: label for setting can't be empty.");
        }
        if (stringArray.length < 2) {
            throw new wJp("Enum settings should have at least two options.");
        }
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(Pw pw2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(pw2 != null));
        assert (cNz.qpf(this.mSetting == null));
        this.mSetting = pw2;
        this.setTarget(pw2.Wcd());
        this.connectEnableAndVisibleValues(pw2.gqj(), pw2.LDt());
    }

    public void disconnectFromSetting(Pw pw2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(pw2 != null));
        assert (cNz.qpf(this.mSetting == pw2));
        this.disconnectEnableAndVisibleValues(pw2.gqj(), pw2.LDt());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(Wx wx2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.qpf(this.mSetting == null));
        assert (cNz.DmN(wx2 != null));
        this.mSetting = wx2;
        this.setTarget(wx2.eh_());
        this.connectEnableAndVisibleValues(wx2.dTJ(), wx2.nfh());
    }

    public void disconnectFromSetting(Wx wx2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(wx2 != null));
        assert (cNz.qpf(this.mSetting == wx2));
        this.disconnectEnableAndVisibleValues(wx2.dTJ(), wx2.nfh());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(Ovv ovv, Ovv ovv2) {
        this.mIsEnabled = ovv;
        this.mIsVisible = ovv2;
    }

    private void disconnectEnableAndVisibleValues(Ovv ovv, Ovv ovv2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        if (this.mIsVisible != null) {
            this.mIsVisible.setValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public cKQ getSetting() {
        return this.mSetting;
    }
}

