/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

class MIDIEventFilter {
    private int mCheckMask;
    private int mMatchMask;
    private final int mPort;
    private XbA mControlSurfaceInstance;

    MIDIEventFilter(XbA xbA, int n2, String string) {
        this.mControlSurfaceInstance = xbA;
        if (string.length() != 6) {
            throw new wJp("Invalid filter");
        }
        this.mPort = n2;
        for (int i2 = 0; i2 < 6; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = i2 / 2;
            int n5 = i2 & 1;
            int n6 = n4 * 8 + (1 - n5) * 4;
            if (c2 == '?') continue;
            this.mCheckMask |= 15 << n6;
            int n7 = Integer.parseInt(String.valueOf(c2), 16);
            this.mMatchMask |= (n7 & 0xF) << n6;
        }
    }

    public boolean matches(int n2) {
        return ((n2 ^ this.mMatchMask) & this.mCheckMask) == 0;
    }

    int getCheckMask() {
        return this.mCheckMask;
    }

    int getMatchMask() {
        return this.mMatchMask;
    }
}

