/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.flt.app.pMW;
import com.bitwig.flt.control_surface.proxy.ListToFixedSizeWindowValue$1;
import com.bitwig.flt.control_surface.proxy.ListToFixedSizeWindowValue$ChangeListener;
import java.util.ArrayList;
import java.util.List;

public class ListToFixedSizeWindowValue
extends ewn {
    private ArrayList mSlaves;
    private fpp mCanScrollUp;
    private fpp mCanScrollDown;
    private fpp mCanScrollPageUp;
    private fpp mCanScrollPageDown;
    private SbT mWindowOffset;
    private SbT mListItemCount;
    private final int mWindowSize;
    private final gBF mList;
    private List mCurrentWindow;
    private ListToFixedSizeWindowValue$ChangeListener mListener;
    private boolean mHasBeenDisposed;
    private int mPageAlignment;
    private boolean mHasInvalidatedWindow;

    public ListToFixedSizeWindowValue(int n2, gBF gBF2, ListToFixedSizeWindowValue$ChangeListener changeListener) {
        super(true);
        assert (cNz.Gqs(n2 > 0));
        this.mWindowSize = n2;
        this.mList = gBF2;
        this.mListener = changeListener;
        this.mWindowOffset = new SbT(0);
        this.mListItemCount = new SbT(0);
        this.mSlaves = new ArrayList(3);
        this.mCanScrollUp = new fpp(false);
        this.mCanScrollDown = new fpp(false);
        this.mCanScrollPageUp = new fpp(false);
        this.mCanScrollPageDown = new fpp(false);
        this.addSource(this.mList);
    }

    public void addSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.add(listToFixedSizeWindowValue);
        listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), true, false);
    }

    public void removeSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.remove(listToFixedSizeWindowValue);
    }

    private void invalidateWindow() {
        if (!this.mHasInvalidatedWindow) {
            this.mHasInvalidatedWindow = true;
            pMW.QOM().DmN(new ListToFixedSizeWindowValue$1(this));
        }
    }

    private void updateWindow() {
        int n2;
        int n4;
        if (this.mHasBeenDisposed || this.mWindowSize == 0) {
            return;
        }
        List list = this.mCurrentWindow;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.mWindowSize);
        int n5 = this.mList.Gqs();
        for (n4 = 0; n4 < this.mWindowSize; ++n4) {
            n2 = this.mWindowOffset.getValue() + n4;
            if (n2 < n5) {
                arrayList.add(this.mList.Gqs(n2));
                continue;
            }
            arrayList.add(null);
        }
        n4 = this.mCurrentWindow == null ? 1 : 0;
        this.mCurrentWindow = arrayList;
        if (n4 != 0) {
            n2 = 0;
            for (Object e2 : arrayList) {
                this.mListener.onAssign(n2++, null, e2);
            }
        } else {
            for (n2 = 0; n2 < this.mWindowSize; ++n2) {
                if (arrayList.get(n2) == list.get(n2)) continue;
                this.mListener.onAssign(n2, list.get(n2), arrayList.get(n2));
            }
        }
        this.mListItemCount.setValue(n5);
        this.updateScrollableStatus();
    }

    public fpp getCanScrollDown() {
        return this.mCanScrollDown;
    }

    public fpp getCanScrollUp() {
        return this.mCanScrollUp;
    }

    public fpp getCanScrollPageDown() {
        return this.mCanScrollPageDown;
    }

    public fpp getCanScrollPageUp() {
        return this.mCanScrollPageUp;
    }

    private void updateScrollableStatus() {
        int n2 = this.mList.Gqs();
        this.mCanScrollUp.Gnn(this.mWindowOffset.getValue() > 0);
        this.mCanScrollDown.Gnn(this.mWindowOffset.getValue() < n2 - this.mWindowSize);
        this.mCanScrollPageUp.Gnn(this.mWindowOffset.getValue() > 0);
        int n4 = (n2 - 1) / this.mWindowSize * this.mWindowSize;
        this.mCanScrollPageDown.Gnn(this.mWindowOffset.getValue() < n4);
    }

    public void dispose() {
        assert (cNz.qpf(!this.mHasBeenDisposed));
        this.removeSource(this.mList);
        this.mHasBeenDisposed = true;
    }

    public void shiftWindow(int n2) {
        this.shiftWindow(n2, false);
    }

    public void shiftWindow(int n2, boolean bl2) {
        this.scrollToOffset(this.mWindowOffset.getValue() + n2, bl2, false);
    }

    public void shiftWindowPage(int n2) {
        int n4 = this.mWindowOffset.getValue() + n2 * this.mWindowSize;
        this.scrollToOffset(n4, true, true);
    }

    public void scrollTo(int n2) {
        this.scrollToOffset(n2, false, true);
    }

    public void scrollToOffset(int n2, boolean bl2, boolean bl3) {
        int n4;
        int n5 = bl3 ? this.quantizePosition(n2) : (n4 = Math.max(0, Math.min(n2, this.mList.Gqs() - (bl2 ? 1 : this.mWindowSize))));
        if (this.mWindowOffset.getValue() != n4) {
            this.mWindowOffset.setValue(n4);
            this.updateWindow();
            for (ListToFixedSizeWindowValue listToFixedSizeWindowValue : this.mSlaves) {
                listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), bl2, false);
            }
        }
    }

    protected int quantizePosition(int n2) {
        int n4 = this.mPageAlignment % this.mWindowSize;
        int n5 = (n2 - n4) / this.mWindowSize * this.mWindowSize + n4;
        if (n5 < this.mWindowOffset.getValue() - this.mWindowSize) {
            n5 += this.mWindowSize;
        }
        int n6 = (this.mList.Gqs() - 1) / this.mWindowSize * this.mWindowSize;
        return EvG.Gnn(n5, 0, n6);
    }

    @Override
    public void changedItems(gBF gBF2, int n2, int n4) {
        this.invalidateWindow();
    }

    @Override
    public void addedAsListenerTo(gBF gBF2) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(gBF gBF2) {
        for (int i2 = 0; i2 < this.mWindowSize; ++i2) {
            if (this.mCurrentWindow == null || this.mCurrentWindow.get(i2) == null) continue;
            this.mListener.onAssign(i2, this.mCurrentWindow.get(i2), null);
        }
        this.mListItemCount.setValue(0);
        this.updateScrollableStatus();
    }

    @Override
    public void insertedItems(gBF gBF2, int n2, int n4) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveItems(gBF gBF2, int n2, int n4) {
        this.invalidateWindow();
    }

    @Override
    protected void insertedItem(gBF gBF2, Object object, int n2) {
        this.invalidateWindow();
    }

    @Override
    protected void aboutToRemoveItem(gBF gBF2, Object object, int n2) {
        this.invalidateWindow();
    }

    public gBF getList() {
        return this.mList;
    }

    public gTG getPosition() {
        return this.mWindowOffset;
    }

    public gTG getListItemCount() {
        return this.mListItemCount;
    }

    public int getPageAlignment() {
        return this.mPageAlignment;
    }

    public void setPageAlignment(int n2) {
        this.mPageAlignment = n2;
    }

    static /* synthetic */ void access$000(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        listToFixedSizeWindowValue.updateWindow();
    }

    static /* synthetic */ boolean access$102(ListToFixedSizeWindowValue listToFixedSizeWindowValue, boolean bl2) {
        listToFixedSizeWindowValue.mHasInvalidatedWindow = bl2;
        return listToFixedSizeWindowValue.mHasInvalidatedWindow;
    }
}

