/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.document.core.iface.vt2;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n2, int n4) {
        super(controlSurfaceObject, "DrumPadBank-" + n2, n2, n4);
        if (n2 < 1) {
            throw new wJp("At least 1 track is required.");
        }
        this.mNumLanes = n2;
        this.mPads = new ArrayList(n2);
        this.mChannelScrollStepSize = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n4, this.mIsIndicating);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return nqU.class;
    }

    protected vt2 getDocumentFromTarget(nqU nqU2) {
        return nqU2.Exo();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (cNz.DmN(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n2, int n4, String string) {
        return new DrumPadProxy(this, string + n4, n4, n2, this.mIsIndicating);
    }

    protected gBF getChannelsListValueFromTarget(nqU nqU2) {
        return nqU2.Gqs();
    }

    protected void connectToTarget(nqU nqU2) {
        int n2 = Integer.MAX_VALUE;
        int n4 = -1;
        for (xHL xHL2 : nqU2.fS_()) {
            int n5 = xHL2.HrD().qpf();
            n2 = Math.min(n5, n2);
            n4 = Math.max(n5, n4);
        }
        int n6 = this.mChannelBankUpdater.getScrollPositionValue();
        if (n4 >= 0 && (n6 < n2 || n6 > n4)) {
            int n7 = n2 / 4;
            this.mChannelBankUpdater.doScrollTo(4 * n7);
        } else {
            this.mChannelBankUpdater.doScrollTo(36);
        }
    }

    protected void disconnectFromTarget(nqU nqU2) {
    }
}

