/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$1;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$2;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$SelectedPageIndexValue;
import com.bitwig.flt.control_surface.proxy.RemoteControlProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlsPageProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableIntegerValueProxy;
import com.bitwig.flt.control_surface.values.StringArrayValueProxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class CursorRemoteControlsPageProxy
extends ControlSurfaceDocumentObjectProxy
implements CursorRemoteControlsPage {
    private static final String[] NO_PAGE_NAMES = new String[0];
    private final tNG mPagesChangedListener = new CursorRemoteControlsPageProxy$1(this);
    private boolean mHasScheduledUpdateToPages;
    private List mPages;
    private final StringArrayValueProxy mPageNamesValue;
    private final SettableIntegerValueProxy mSelectedPageIndexValue;
    private final uig mPageNames;
    private final RemoteControlsPageProxy mSelectedPageProxy;
    private fpp mHasPrevParameterPage = new fpp(false);
    private fpp mHasNextParameterPage = new fpp(false);
    private final CursorRemoteControlsPageProxy$SelectedPageIndexValue mSelectedPageIndex = new CursorRemoteControlsPageProxy$SelectedPageIndexValue(this, 0);
    private final BooleanValueProxy mHasNextPageValue;
    private final BooleanValueProxy mHasPreviousPageValue;
    private o1G mPageSelector;
    private boolean mIsChangingPageFromController;
    private final Seo mSelectedPageListener = new CursorRemoteControlsPageProxy$2(this);
    private boolean mHasScheduledUpdateSelectedPage;

    protected CursorRemoteControlsPageProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2) {
        super(controlSurfaceObject);
        assert (cNz.DmN(string != null));
        assert (cNz.DmN(n2 >= 1));
        this.mSelectedPageProxy = new RemoteControlsPageProxy(this, string, n2);
        this.mPageNamesValue = new StringArrayValueProxy((ControlSurfaceObject)this, NO_PAGE_NAMES);
        this.mPageNames = new uig(NO_PAGE_NAMES);
        this.mSelectedPageIndexValue = new SettableIntegerValueProxy((ControlSurfaceObject)this, -1);
        this.mHasNextPageValue = new BooleanValueProxy(this);
        this.mHasPreviousPageValue = new BooleanValueProxy(this);
    }

    @Override
    public int getParameterCount() {
        return this.mSelectedPageProxy.getParameterCount();
    }

    @Override
    public RemoteControlProxy getParameter(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        return this.mSelectedPageProxy.getParameter(n2);
    }

    public RemoteControlsPageProxy getSelectedPage() {
        return this.mSelectedPageProxy;
    }

    @Override
    public StringValue getName() {
        this.newSince(4);
        return this.mSelectedPageProxy.getName();
    }

    @Override
    public SettableIntegerValue selectedPageIndex() {
        return this.mSelectedPageIndexValue;
    }

    private void doSelectPageAtIndex(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mPageSelector != null && n2 >= 0) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Gnn(n2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPreviousPage(boolean bl2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectPreviousPage(bl2));
    }

    private void doSelectPreviousPage(boolean bl2) {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Gqs(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectFirst() {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(this::doSelectFirst);
    }

    private void doSelectFirst() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Gqs();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectLast() {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(this::doSelectLast);
    }

    private void doSelectLast() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.DmN();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNext() {
        this.selectNextPage(false);
    }

    @Override
    public void selectNextPage(boolean bl2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectNextPage(bl2));
    }

    private void doSelectNextPage(boolean bl2) {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Gnn(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNextPageMatching(String string, boolean bl2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (string == null) {
            throw new wJp("expression cannot be null");
        }
        this.exec(() -> this.doSelectNextPageMatching(string, bl2));
    }

    private void doSelectNextPageMatching(String string, boolean bl2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Gnn(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPrevious() {
        this.selectPreviousPage(false);
    }

    @Override
    public void selectPreviousPageMatching(String string, boolean bl2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (string == null) {
            throw new wJp("expression cannot be null");
        }
        this.exec(() -> this.doSelectPreviousPageMatching(string, bl2));
    }

    private void doSelectPreviousPageMatching(String string, boolean bl2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Gqs(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasNextPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasPreviousPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mHasPreviousPageValue;
    }

    @Override
    public BooleanValue hasNext() {
        return this.mHasNextPageValue;
    }

    protected abstract o1G getPageSelectorForRemoteControls(IJE var1);

    protected void connectToTarget(IJE iJE) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(iJE != null));
        assert (cNz.DmN(this.mPageSelector == null));
        this.mPageSelector = this.getPageSelectorForRemoteControls(iJE);
        this.updatePages();
        this.mPageNamesValue.setTarget(this.mPageNames);
        iJE.Gnn(this.mPagesChangedListener);
        this.mPageSelector.Gnn(this.mSelectedPageListener);
        this.mSelectedPageIndexValue.setTarget(this.mSelectedPageIndex);
        this.mHasNextPageValue.setTarget(this.mHasNextParameterPage);
        this.mHasPreviousPageValue.setTarget(this.mHasPrevParameterPage);
        this.updateSelectedPage();
    }

    protected void disconnectFromTarget(IJE iJE) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(iJE != null));
        assert (cNz.DmN(this.mPageSelector != null));
        this.mSelectedPageIndexValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mPageNamesValue.clearTarget();
        this.mPageSelector.Gqs(this.mSelectedPageListener);
        iJE.Gqs(this.mPagesChangedListener);
        this.mPageSelector = null;
        this.mSelectedPageProxy.clearTarget();
    }

    private void invalidatePages() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPages) {
            this.mHasScheduledUpdateToPages = true;
            this.runAtEndOfEvent(this::updatePages);
        }
    }

    @Override
    public StringArrayValue pageNames() {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        return this.mPageNamesValue;
    }

    protected void ensurePagesUpdated() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mHasScheduledUpdateToPages) {
            this.updatePages();
        }
    }

    private void updatePages() {
        assert (cNz.DmN(this.isDocumentThread()));
        this.mHasScheduledUpdateToPages = false;
        this.setPages(this.calculatePages());
    }

    private void setPages(List list) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(list != null));
        if (!yLr.Gnn(this.mPages, list)) {
            this.mPages = list;
            this.pagesChanged();
        }
        this.updatePageNames();
    }

    protected void pagesChanged() {
        assert (cNz.DmN(this.isDocumentThread()));
        this.updateHasNextAndPrevPage();
    }

    private void updateHasNextAndPrevPage() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mHasScheduledUpdateSelectedPage) {
            this.updateSelectedPage();
        }
        if (this.getTarget() != null) {
            int n2 = this.getPageCount();
            int n4 = this.mSelectedPageIndex.getValue();
            assert (cNz.DmN(n4 == this.clampPageToRange(n4)));
            this.mHasPrevParameterPage.Gnn(n4 > 0);
            this.mHasNextParameterPage.Gnn(n4 < n2 - 1);
        } else {
            this.mHasPrevParameterPage.Gnn(false);
            this.mHasNextParameterPage.Gnn(false);
        }
    }

    private void scheduleUpdateSelectedPage() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateSelectedPage) {
            this.mHasScheduledUpdateSelectedPage = true;
            this.runAtEndOfEvent(this::updateSelectedPage);
        }
    }

    private void updateSelectedPage() {
        assert (cNz.DmN(this.isDocumentThread()));
        this.ensurePagesUpdated();
        this.mHasScheduledUpdateSelectedPage = false;
        iQm iQm2 = this.mPageSelector != null ? this.mPageSelector.qpf() : null;
        this.mSelectedPageProxy.setTarget(iQm2);
        if (iQm2 != null) {
            int n2 = this.getPageIndex(iQm2);
            assert (cNz.DmN(n2 >= 0));
            this.mSelectedPageIndex.doSetValue(n2);
            if (this.mIsChangingPageFromController) {
                this.showMappingNotification((String)iQm2.gD_().getValue());
            }
        } else {
            this.mSelectedPageIndex.doSetValue(0);
        }
        this.updateHasNextAndPrevPage();
    }

    protected int clampPageToRange(int n2) {
        int n4 = this.getPageCount();
        return n4 > 0 ? EvG.Gnn(n2, 0, n4 - 1) : 0;
    }

    private List calculatePages() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (this.mPageSelector == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mPageSelector.Gnn();
    }

    private void updatePageNames() {
        this.setPageNames(this.calculatePageNames());
    }

    private String[] calculatePageNames() {
        int n2 = this.getPageCount();
        if (n2 == 0) {
            return NO_PAGE_NAMES;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)this.getPageAt(i2).gD_().getValue();
        }
        return stringArray;
    }

    private void setPageNames(String[] stringArray) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(stringArray != null));
        Object[] objectArray = (String[])this.mPageNames.getValue();
        assert (cNz.DmN(objectArray != null));
        if (!Arrays.equals(stringArray, objectArray)) {
            this.mPageNames.setValue(stringArray);
        }
    }

    public int getPageCount() {
        assert (cNz.DmN(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (cNz.DmN(!this.mHasScheduledUpdateToPages));
        return this.mPages != null ? this.mPages.size() : 0;
    }

    public iQm getPageAt(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (cNz.DmN(!this.mHasScheduledUpdateToPages));
        return (iQm)this.mPages.get(n2);
    }

    public int getPageIndex(iQm iQm2) {
        assert (cNz.DmN(iQm2 != null));
        assert (cNz.DmN(this.isDocumentThread()));
        this.ensurePagesUpdated();
        return this.mPages.indexOf(iQm2);
    }

    protected void showMappingNotification(String string) {
        if (this.getHost().getNotificationSettings().shouldShowMappingNotifications()) {
            this.getControlSurface().Gnn(string, "Mapping");
        }
    }

    static /* synthetic */ void access$000(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy) {
        cursorRemoteControlsPageProxy.invalidatePages();
    }

    static /* synthetic */ void access$100(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy, int n2) {
        cursorRemoteControlsPageProxy.doSelectPageAtIndex(n2);
    }

    static /* synthetic */ void access$300(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy) {
        cursorRemoteControlsPageProxy.scheduleUpdateSelectedPage();
    }
}

